/*
 * Decompiled with CFR 0.152.
 */
package adams.multiprocess;

import adams.core.License;
import adams.core.Pausable;
import adams.core.annotation.MixedCopyright;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@MixedCopyright(copyright="Doug Lea with assistance from members of JCP JSR-166 Expert Group", license=License.CC_PD, url="http://svn.apache.org/repos/asf/harmony/standard/classlib/trunk/modules/concurrent/src/main/java/java/util/concurrent/ThreadPoolExecutor.java")
public class PausableFixedThreadPoolExecutor
extends ThreadPoolExecutor
implements Pausable {
    protected boolean m_IsPaused;
    protected ReentrantLock m_PauseLock = new ReentrantLock();
    protected Condition m_Unpaused = this.m_PauseLock.newCondition();

    public PausableFixedThreadPoolExecutor(int numThreads) {
        super(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.m_PauseLock.lock();
        try {
            while (this.m_IsPaused) {
                this.m_Unpaused.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.m_PauseLock.unlock();
        }
    }

    @Override
    public boolean isPaused() {
        return this.m_IsPaused;
    }

    @Override
    public void pauseExecution() {
        this.m_PauseLock.lock();
        try {
            this.m_IsPaused = true;
        }
        finally {
            this.m_PauseLock.unlock();
        }
    }

    @Override
    public void resumeExecution() {
        this.m_PauseLock.lock();
        try {
            this.m_IsPaused = false;
            this.m_Unpaused.signalAll();
        }
        finally {
            this.m_PauseLock.unlock();
        }
    }
}

