/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.List;
import org.openstreetmap.gui.jmapviewer.AbstractLayer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.Style;

public class LayerGroup
extends AbstractLayer {
    private List<AbstractLayer> layers;

    public LayerGroup(String name) {
        super(name);
    }

    public LayerGroup(String name, String description) {
        super(name, description);
    }

    public LayerGroup(String name, Style style) {
        super(name, style);
    }

    public LayerGroup(String name, String description, Style style) {
        super(name, description, style);
    }

    public LayerGroup(LayerGroup parent, String name) {
        super(parent, name);
    }

    public LayerGroup(LayerGroup parent, String name, String description, Style style) {
        super(name, description, style);
    }

    public List<AbstractLayer> getLayers() {
        return this.layers;
    }

    public void setElements(List<AbstractLayer> layers) {
        this.layers = layers;
    }

    public Layer addLayer(String name) {
        Layer layer = new Layer(this, name);
        this.layers = LayerGroup.add(this.layers, layer);
        return layer;
    }

    public LayerGroup add(AbstractLayer layer) {
        layer.setParent(this);
        this.layers = LayerGroup.add(this.layers, layer);
        return this;
    }

    public void calculateVisibleTexts() {
        Boolean calculate = null;
        if (this.layers != null && this.layers.size() > 0) {
            calculate = this.layers.get(0).isVisibleTexts();
            for (int i = 1; i < this.layers.size(); ++i) {
                calculate = this.resultOf(calculate, this.layers.get(i).isVisibleTexts());
            }
        }
        this.setVisibleTexts(calculate);
        if (this.getParent() != null) {
            this.getParent().calculateVisibleTexts();
        }
    }

    public Boolean resultOf(Boolean b1, Boolean b2) {
        if (b1 == null || b2 == null) {
            return null;
        }
        if (b1.booleanValue() == b2.booleanValue()) {
            return (boolean)b1;
        }
        return null;
    }
}

