/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public abstract class ImageDistortBasic<Input extends ImageSingleBand, Output extends ImageSingleBand>
implements ImageDistort<Input, Output> {
    protected PixelTransform_F32 dstToSrc;
    protected InterpolatePixelS<Input> interp;
    protected ImageBorder<Input> border;
    protected int x0;
    protected int y0;
    protected int x1;
    protected int y1;
    protected Input srcImg;
    protected Output dstImg;

    public ImageDistortBasic(InterpolatePixelS<Input> interp, ImageBorder<Input> border) {
        this.interp = interp;
        this.border = border;
    }

    @Override
    public void setModel(PixelTransform_F32 dstToSrc) {
        this.dstToSrc = dstToSrc;
    }

    @Override
    public void apply(Input srcImg, Output dstImg) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageSingleBand)dstImg).width;
        this.y1 = ((ImageSingleBand)dstImg).height;
        if (this.border != null) {
            this.applyBorder();
        } else {
            this.applyNoBorder();
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        this.init(srcImg, dstImg);
        this.x0 = dstX0;
        this.y0 = dstY0;
        this.x1 = dstX1;
        this.y1 = dstY1;
        if (this.border != null) {
            this.applyBorder();
        } else {
            this.applyNoBorder();
        }
    }

    private void init(Input srcImg, Output dstImg) {
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
    }

    public void applyBorder() {
        this.border.setImage(this.srcImg);
        float minInterpX = this.interp.getFastBorderX();
        float minInterpY = this.interp.getFastBorderY();
        float maxInterpX = ((ImageBase)this.srcImg).getWidth() - this.interp.getFastBorderX() - 1;
        float maxInterpY = ((ImageBase)this.srcImg).getHeight() - this.interp.getFastBorderY() - 1;
        float widthF = ((ImageBase)this.srcImg).getWidth() - 1;
        float heightF = ((ImageBase)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX < minInterpX || this.dstToSrc.distX > maxInterpX || this.dstToSrc.distY < minInterpY || this.dstToSrc.distY > maxInterpY) {
                    if (this.dstToSrc.distX < 0.0f || this.dstToSrc.distX > widthF || this.dstToSrc.distY < 0.0f || this.dstToSrc.distY > heightF) {
                        this.assign(indexDst, (float)this.border.getGeneral((int)this.dstToSrc.distX, (int)this.dstToSrc.distY));
                    } else {
                        this.assign(indexDst, this.interp.get(this.dstToSrc.distX, this.dstToSrc.distY));
                    }
                } else {
                    this.assign(indexDst, this.interp.get_fast(this.dstToSrc.distX, this.dstToSrc.distY));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    public void applyNoBorder() {
        float minInterpX = this.interp.getFastBorderX();
        float minInterpY = this.interp.getFastBorderY();
        float maxInterpX = ((ImageBase)this.srcImg).getWidth() - this.interp.getFastBorderX() - 1;
        float maxInterpY = ((ImageBase)this.srcImg).getHeight() - this.interp.getFastBorderY() - 1;
        float widthF = ((ImageBase)this.srcImg).getWidth() - 1;
        float heightF = ((ImageBase)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX < minInterpX || this.dstToSrc.distX > maxInterpX || this.dstToSrc.distY < minInterpY || this.dstToSrc.distY > maxInterpY) {
                    if (this.dstToSrc.distX >= 0.0f && this.dstToSrc.distX <= widthF && this.dstToSrc.distY >= 0.0f && this.dstToSrc.distY <= heightF) {
                        this.assign(indexDst, this.interp.get(this.dstToSrc.distX, this.dstToSrc.distY));
                    }
                } else {
                    this.assign(indexDst, this.interp.get_fast(this.dstToSrc.distX, this.dstToSrc.distY));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    protected abstract void assign(int var1, float var2);
}

