/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.PolynomialPixel;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageType;

public class ImplPolynomialPixel_F32
extends PolynomialPixel<ImageFloat32> {
    public ImplPolynomialPixel_F32(int maxDegree, float min, float max) {
        super(maxDegree, min, max);
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(((ImageFloat32)this.image).width - 1) || y > (float)(((ImageFloat32)this.image).height - 1)) {
            throw new IllegalArgumentException("Pixel out of bounds. " + x + " " + y);
        }
        int width = ((ImageFloat32)this.image).getWidth();
        int height = ((ImageFloat32)this.image).getHeight();
        int xt = (int)x;
        int yt = (int)y;
        int x0 = xt - this.M / 2 + this.offM;
        int x1 = x0 + this.M;
        int y0 = yt - this.M / 2 + this.offM;
        int y1 = y0 + this.M;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > width) {
            x1 = width;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > height) {
            y1 = height;
        }
        int horizM = x1 - x0;
        int vertM = y1 - y0;
        this.interp1D.setInput(this.horiz, horizM);
        for (int i = 0; i < vertM; ++i) {
            for (int j = 0; j < horizM; ++j) {
                this.horiz[j] = ((ImageFloat32)this.image).get(j + x0, i + y0);
            }
            this.vert[i] = this.interp1D.process(x - (float)x0, 0, horizM - 1);
        }
        this.interp1D.setInput(this.vert, vertM);
        float ret = this.interp1D.process(y - (float)y0, 0, vertM - 1);
        if (ret > this.max) {
            ret = this.max;
        } else if (ret < this.min) {
            ret = this.min;
        }
        return ret;
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        int x0 = xt - this.M / 2 + this.offM;
        int y0 = yt - this.M / 2 + this.offM;
        this.interp1D.setInput(this.horiz, this.horiz.length);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.M; ++j) {
                this.horiz[j] = ((ImageFloat32)this.image).get(j + x0, i + y0);
            }
            this.vert[i] = this.interp1D.process(x - (float)x0, 0, this.M - 1);
        }
        this.interp1D.setInput(this.vert, this.vert.length);
        float ret = this.interp1D.process(y - (float)y0, 0, this.M - 1);
        if (ret > this.max) {
            ret = this.max;
        } else if (ret < this.min) {
            ret = this.min;
        }
        return ret;
    }

    @Override
    public ImageType<ImageFloat32> getImageType() {
        return ImageType.single(ImageFloat32.class);
    }
}

