/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.filter.convolve.ConvolveWithBorderSparse;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;

public class FactoryConvolveSparse {
    public static <T extends ImageSingleBand, K extends Kernel2D> ImageConvolveSparse<T, K> create(Class<T> imageType, K kernel) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Convolve_F32((Kernel2D_F32)kernel);
        }
        return new Convolve_I((Kernel2D_I32)kernel);
    }

    public static <T extends ImageSingleBand, K extends Kernel2D> ImageConvolveSparse<T, K> create(Class<T> imageType) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Convolve_F32(null);
        }
        return new Convolve_I(null);
    }

    public static class Convolve_I
    extends ImageConvolveSparse<ImageInteger, Kernel2D_I32> {
        public Convolve_I(Kernel2D_I32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.convolve((Kernel2D_I32)this.kernel, (ImageBorder_I32)this.image, x, y);
        }
    }

    public static class Convolve_F32
    extends ImageConvolveSparse<ImageFloat32, Kernel2D_F32> {
        public Convolve_F32(Kernel2D_F32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.convolve((Kernel2D_F32)this.kernel, (ImageBorder_F32)this.image, x, y);
        }
    }
}

