/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.announce;

import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.client.announce.TrackerClient;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.http.HTTPAnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.http.HTTPTrackerMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPTrackerClient
extends TrackerClient {
    protected static final Logger logger = LoggerFactory.getLogger(HTTPTrackerClient.class);

    protected HTTPTrackerClient(SharedTorrent torrent, Peer peer, URI tracker) {
        super(torrent, peer, tracker);
    }

    @Override
    public void announce(TrackerMessage.AnnounceRequestMessage.RequestEvent event, boolean inhibitEvents) throws AnnounceException {
        InputStream in;
        HttpURLConnection conn;
        block22: {
            logger.info("Announcing{} to tracker with {}U/{}D/{}L bytes...", new Object[]{this.formatAnnounceEvent(event), this.torrent.getUploaded(), this.torrent.getDownloaded(), this.torrent.getLeft()});
            URL target = null;
            try {
                HTTPAnnounceRequestMessage request = this.buildAnnounceRequest(event);
                target = request.buildAnnounceURL(this.tracker.toURL());
            }
            catch (MalformedURLException mue) {
                throw new AnnounceException("Invalid announce URL (" + mue.getMessage() + ")", mue);
            }
            catch (TrackerMessage.MessageValidationException mve) {
                throw new AnnounceException("Announce request creation violated expected protocol (" + mve.getMessage() + ")", mve);
            }
            catch (IOException ioe) {
                throw new AnnounceException("Error building announce request (" + ioe.getMessage() + ")", ioe);
            }
            conn = null;
            in = null;
            try {
                conn = (HttpURLConnection)target.openConnection();
                in = conn.getInputStream();
            }
            catch (IOException ioe) {
                if (conn == null) break block22;
                in = conn.getErrorStream();
            }
        }
        if (in == null) {
            throw new AnnounceException("No response or unreachable tracker!");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(in);
            HTTPTrackerMessage message = HTTPTrackerMessage.parse(ByteBuffer.wrap(baos.toByteArray()));
            this.handleTrackerAnnounceResponse(message, inhibitEvents);
        }
        catch (IOException ioe) {
            throw new AnnounceException("Error reading tracker response!", ioe);
        }
        catch (TrackerMessage.MessageValidationException mve) {
            throw new AnnounceException("Tracker message violates expected protocol (" + mve.getMessage() + ")", mve);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                logger.warn("Problem ensuring error stream closed!", (Throwable)ioe);
            }
            InputStream err = conn.getErrorStream();
            if (err != null) {
                try {
                    err.close();
                }
                catch (IOException ioe) {
                    logger.warn("Problem ensuring error stream closed!", (Throwable)ioe);
                }
            }
        }
    }

    private HTTPAnnounceRequestMessage buildAnnounceRequest(TrackerMessage.AnnounceRequestMessage.RequestEvent event) throws UnsupportedEncodingException, IOException, TrackerMessage.MessageValidationException {
        return HTTPAnnounceRequestMessage.craft(this.torrent.getInfoHash(), this.peer.getPeerId().array(), this.peer.getPort(), this.torrent.getUploaded(), this.torrent.getDownloaded(), this.torrent.getLeft(), true, false, event, this.peer.getIp(), 50);
    }
}

