/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.announce;

import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.client.announce.AnnounceResponseListener;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class TrackerClient {
    private final Set<AnnounceResponseListener> listeners = new HashSet<AnnounceResponseListener>();
    protected final SharedTorrent torrent;
    protected final Peer peer;
    protected final URI tracker;

    public TrackerClient(SharedTorrent torrent, Peer peer, URI tracker) {
        this.torrent = torrent;
        this.peer = peer;
        this.tracker = tracker;
    }

    public void register(AnnounceResponseListener listener) {
        this.listeners.add(listener);
    }

    public URI getTrackerURI() {
        return this.tracker;
    }

    public abstract void announce(TrackerMessage.AnnounceRequestMessage.RequestEvent var1, boolean var2) throws AnnounceException;

    protected void close() {
    }

    protected String formatAnnounceEvent(TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        return TrackerMessage.AnnounceRequestMessage.RequestEvent.NONE.equals((Object)event) ? "" : String.format(" %s", event.name());
    }

    protected void handleTrackerAnnounceResponse(TrackerMessage message, boolean inhibitEvents) throws AnnounceException {
        if (message instanceof TrackerMessage.ErrorMessage) {
            TrackerMessage.ErrorMessage error = (TrackerMessage.ErrorMessage)((Object)message);
            throw new AnnounceException(error.getReason());
        }
        if (!(message instanceof TrackerMessage.AnnounceResponseMessage)) {
            throw new AnnounceException("Unexpected tracker message type " + message.getType().name() + "!");
        }
        if (inhibitEvents) {
            return;
        }
        TrackerMessage.AnnounceResponseMessage response = (TrackerMessage.AnnounceResponseMessage)((Object)message);
        this.fireAnnounceResponseEvent(response.getComplete(), response.getIncomplete(), response.getInterval());
        this.fireDiscoveredPeersEvent(response.getPeers());
    }

    protected void fireAnnounceResponseEvent(int complete, int incomplete, int interval) {
        for (AnnounceResponseListener listener : this.listeners) {
            listener.handleAnnounceResponse(interval, complete, incomplete);
        }
    }

    protected void fireDiscoveredPeersEvent(List<Peer> peers) {
        for (AnnounceResponseListener listener : this.listeners) {
            listener.handleDiscoveredPeers(peers);
        }
    }
}

