/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.announce;

import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.client.announce.TrackerClient;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.udp.UDPAnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.udp.UDPConnectRequestMessage;
import com.turn.ttorrent.common.protocol.udp.UDPConnectResponseMessage;
import com.turn.ttorrent.common.protocol.udp.UDPTrackerMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPTrackerClient
extends TrackerClient {
    protected static final Logger logger = LoggerFactory.getLogger(UDPTrackerClient.class);
    private static final int UDP_BASE_TIMEOUT_SECONDS = 15;
    private static final int UDP_MAX_TRIES = 8;
    private static final int UDP_MAX_TRIES_ON_STOPPED = 1;
    private static final int UDP_PACKET_LENGTH = 512;
    private final InetSocketAddress address;
    private final Random random;
    private DatagramSocket socket;
    private Date connectionExpiration;
    private long connectionId;
    private int transactionId;
    private boolean stop;

    protected UDPTrackerClient(SharedTorrent torrent, Peer peer, URI tracker) throws UnknownHostException {
        super(torrent, peer, tracker);
        if (!(InetAddress.getByName(peer.getIp()) instanceof Inet4Address)) {
            throw new UnsupportedAddressTypeException();
        }
        this.address = new InetSocketAddress(tracker.getHost(), tracker.getPort());
        this.socket = null;
        this.random = new Random();
        this.connectionExpiration = null;
        this.stop = false;
    }

    @Override
    public void announce(TrackerMessage.AnnounceRequestMessage.RequestEvent event, boolean inhibitEvents) throws AnnounceException {
        logger.info("Announcing{} to tracker with {}U/{}D/{}L bytes...", new Object[]{this.formatAnnounceEvent(event), this.torrent.getUploaded(), this.torrent.getDownloaded(), this.torrent.getLeft()});
        State state = State.CONNECT_REQUEST;
        int maxAttempts = TrackerMessage.AnnounceRequestMessage.RequestEvent.STOPPED.equals((Object)event) ? 1 : 8;
        int attempts = -1;
        try {
            this.socket = new DatagramSocket();
            this.socket.connect(this.address);
            block11: while (++attempts <= maxAttempts) {
                this.transactionId = this.random.nextInt();
                if (this.connectionExpiration != null) {
                    if (new Date().before(this.connectionExpiration)) {
                        state = State.ANNOUNCE_REQUEST;
                    } else {
                        logger.debug("Announce connection ID expired, reconnecting with tracker...");
                    }
                }
                switch (state) {
                    case CONNECT_REQUEST: {
                        this.send(UDPConnectRequestMessage.craft(this.transactionId).getData());
                        try {
                            this.handleTrackerConnectResponse(UDPTrackerMessage.UDPTrackerResponseMessage.parse(this.recv(attempts)));
                            attempts = -1;
                            continue block11;
                        }
                        catch (SocketTimeoutException ste) {
                            if (!this.stop) continue block11;
                            return;
                        }
                    }
                    case ANNOUNCE_REQUEST: {
                        this.send(this.buildAnnounceRequest(event).getData());
                        try {
                            this.handleTrackerAnnounceResponse(UDPTrackerMessage.UDPTrackerResponseMessage.parse(this.recv(attempts)), inhibitEvents);
                            return;
                        }
                        catch (SocketTimeoutException ste) {
                            if (!this.stop) continue block11;
                            return;
                        }
                    }
                }
                throw new IllegalStateException("Invalid announce state!");
            }
            throw new AnnounceException("Timeout while announcing" + this.formatAnnounceEvent(event) + " to tracker!");
        }
        catch (IOException ioe) {
            throw new AnnounceException("Error while announcing" + this.formatAnnounceEvent(event) + " to tracker: " + ioe.getMessage(), ioe);
        }
        catch (TrackerMessage.MessageValidationException mve) {
            throw new AnnounceException("Tracker message violates expected protocol (" + mve.getMessage() + ")", mve);
        }
    }

    @Override
    protected void handleTrackerAnnounceResponse(TrackerMessage message, boolean inhibitEvents) throws AnnounceException {
        this.validateTrackerResponse(message);
        super.handleTrackerAnnounceResponse(message, inhibitEvents);
    }

    @Override
    protected void close() {
        this.stop = true;
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    private UDPAnnounceRequestMessage buildAnnounceRequest(TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        return UDPAnnounceRequestMessage.craft(this.connectionId, this.transactionId, this.torrent.getInfoHash(), this.peer.getPeerId().array(), this.torrent.getDownloaded(), this.torrent.getUploaded(), this.torrent.getLeft(), event, this.peer.getAddress(), 0, 50, this.peer.getPort());
    }

    private void validateTrackerResponse(TrackerMessage message) throws AnnounceException {
        if (message instanceof TrackerMessage.ErrorMessage) {
            throw new AnnounceException(((TrackerMessage.ErrorMessage)((Object)message)).getReason());
        }
        if (message instanceof UDPTrackerMessage && ((UDPTrackerMessage)message).getTransactionId() != this.transactionId) {
            throw new AnnounceException("Invalid transaction ID!");
        }
    }

    private void handleTrackerConnectResponse(TrackerMessage message) throws AnnounceException {
        this.validateTrackerResponse(message);
        if (!(message instanceof TrackerMessage.ConnectionResponseMessage)) {
            throw new AnnounceException("Unexpected tracker message type " + message.getType().name() + "!");
        }
        UDPConnectResponseMessage connectResponse = (UDPConnectResponseMessage)message;
        this.connectionId = connectResponse.getConnectionId();
        Calendar now = Calendar.getInstance();
        now.add(12, 1);
        this.connectionExpiration = now.getTime();
    }

    private void send(ByteBuffer data) {
        try {
            this.socket.send(new DatagramPacket(data.array(), data.capacity(), this.address));
        }
        catch (IOException ioe) {
            logger.warn("Error sending datagram packet to tracker at {}: {}.", (Object)this.address, (Object)ioe.getMessage());
        }
    }

    private ByteBuffer recv(int attempt) throws IOException, SocketException, SocketTimeoutException {
        int timeout = 15 * (int)Math.pow(2.0, attempt);
        logger.trace("Setting receive timeout to {}s for attempt {}...", (Object)timeout, (Object)attempt);
        this.socket.setSoTimeout(timeout * 1000);
        DatagramPacket p = new DatagramPacket(new byte[512], 512);
        this.socket.receive(p);
        return ByteBuffer.wrap(p.getData(), 0, p.getLength());
    }

    private static enum State {
        CONNECT_REQUEST,
        ANNOUNCE_REQUEST;

    }
}

