/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.peer;

import com.turn.ttorrent.client.Piece;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.peer.MessageListener;
import com.turn.ttorrent.client.peer.PeerActivityListener;
import com.turn.ttorrent.client.peer.PeerExchange;
import com.turn.ttorrent.client.peer.Rate;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.protocol.PeerMessage;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingPeer
extends Peer
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(SharingPeer.class);
    private static final int MAX_PIPELINED_REQUESTS = 5;
    private boolean choking;
    private boolean interesting;
    private boolean choked;
    private boolean interested;
    private SharedTorrent torrent;
    private BitSet availablePieces;
    private Piece requestedPiece;
    private int lastRequestedOffset;
    private BlockingQueue<PeerMessage.RequestMessage> requests;
    private volatile boolean downloading;
    private PeerExchange exchange;
    private Rate download;
    private Rate upload;
    private Set<PeerActivityListener> listeners;
    private Object requestsLock;
    private Object exchangeLock;

    public SharingPeer(String ip, int port, ByteBuffer peerId, SharedTorrent torrent) {
        super(ip, port, peerId);
        this.torrent = torrent;
        this.listeners = new HashSet<PeerActivityListener>();
        this.availablePieces = new BitSet(this.torrent.getPieceCount());
        this.requestsLock = new Object();
        this.exchangeLock = new Object();
        this.reset();
        this.requestedPiece = null;
    }

    public void register(PeerActivityListener listener) {
        this.listeners.add(listener);
    }

    public Rate getDLRate() {
        return this.download;
    }

    public Rate getULRate() {
        return this.upload;
    }

    public synchronized void reset() {
        this.choking = true;
        this.interesting = false;
        this.choked = true;
        this.interested = false;
        this.exchange = null;
        this.requests = null;
        this.lastRequestedOffset = 0;
        this.downloading = false;
    }

    public void choke() {
        if (!this.choking) {
            logger.trace("Choking {}", (Object)this);
            this.send(PeerMessage.ChokeMessage.craft());
            this.choking = true;
        }
    }

    public void unchoke() {
        if (this.choking) {
            logger.trace("Unchoking {}", (Object)this);
            this.send(PeerMessage.UnchokeMessage.craft());
            this.choking = false;
        }
    }

    public boolean isChoking() {
        return this.choking;
    }

    public void interesting() {
        if (!this.interesting) {
            logger.trace("Telling {} we're interested.", (Object)this);
            this.send(PeerMessage.InterestedMessage.craft());
            this.interesting = true;
        }
    }

    public void notInteresting() {
        if (this.interesting) {
            logger.trace("Telling {} we're no longer interested.", (Object)this);
            this.send(PeerMessage.NotInterestedMessage.craft());
            this.interesting = false;
        }
    }

    public boolean isInteresting() {
        return this.interesting;
    }

    public boolean isChoked() {
        return this.choked;
    }

    public boolean isInterested() {
        return this.interested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet getAvailablePieces() {
        BitSet bitSet = this.availablePieces;
        synchronized (bitSet) {
            return (BitSet)this.availablePieces.clone();
        }
    }

    public Piece getRequestedPiece() {
        return this.requestedPiece;
    }

    public synchronized boolean isSeed() {
        return this.torrent.getPieceCount() > 0 && this.getAvailablePieces().cardinality() == this.torrent.getPieceCount();
    }

    public synchronized void bind(SocketChannel channel) throws SocketException {
        this.unbind(true);
        this.exchange = new PeerExchange(this, this.torrent, channel);
        this.exchange.register(this);
        this.download = new Rate();
        this.download.reset();
        this.upload = new Rate();
        this.upload.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.exchangeLock;
        synchronized (object) {
            return this.exchange != null && this.exchange.isConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(boolean force) {
        if (!force) {
            this.cancelPendingRequests();
            this.send(PeerMessage.NotInterestedMessage.craft());
        }
        Object object = this.exchangeLock;
        synchronized (object) {
            if (this.exchange != null) {
                this.exchange.close();
                this.exchange = null;
            }
        }
        this.firePeerDisconnected();
        this.requestedPiece = null;
    }

    public void send(PeerMessage message) throws IllegalStateException {
        if (this.isConnected()) {
            this.exchange.send(message);
        } else {
            logger.warn("Attempting to send a message to non-connected peer {}!", (Object)this);
        }
    }

    public synchronized void downloadPiece(Piece piece) throws IllegalStateException {
        if (this.isDownloading()) {
            IllegalStateException up = new IllegalStateException("Trying to download a piece while previous download not completed!");
            logger.warn("What's going on? {}", (Object)up.getMessage(), (Object)up);
            throw up;
        }
        this.requests = new LinkedBlockingQueue<PeerMessage.RequestMessage>(5);
        this.requestedPiece = piece;
        this.lastRequestedOffset = 0;
        this.requestNextBlocks();
    }

    public boolean isDownloading() {
        return this.downloading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNextBlocks() {
        Object object = this.requestsLock;
        synchronized (object) {
            if (this.requests == null || this.requestedPiece == null) {
                return;
            }
            while (this.requests.remainingCapacity() > 0 && (long)this.lastRequestedOffset < this.requestedPiece.size()) {
                PeerMessage.RequestMessage request = PeerMessage.RequestMessage.craft(this.requestedPiece.getIndex(), this.lastRequestedOffset, Math.min((int)(this.requestedPiece.size() - (long)this.lastRequestedOffset), 16384));
                this.requests.add(request);
                this.send(request);
                this.lastRequestedOffset += request.getLength();
            }
            this.downloading = this.requests.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlockRequest(PeerMessage.PieceMessage message) {
        Object object = this.requestsLock;
        synchronized (object) {
            if (this.requests == null) {
                return;
            }
            for (PeerMessage.RequestMessage request : this.requests) {
                if (request.getPiece() != message.getPiece() || request.getOffset() != message.getOffset()) continue;
                this.requests.remove(request);
                break;
            }
            this.downloading = this.requests.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerMessage.RequestMessage> cancelPendingRequests() {
        Object object = this.requestsLock;
        synchronized (object) {
            HashSet<PeerMessage.RequestMessage> requests = new HashSet<PeerMessage.RequestMessage>();
            if (this.requests != null) {
                for (PeerMessage.RequestMessage request : this.requests) {
                    this.send(PeerMessage.CancelMessage.craft(request.getPiece(), request.getOffset(), request.getLength()));
                    requests.add(request);
                }
            }
            this.requests = null;
            this.downloading = false;
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void handleMessage(PeerMessage msg) {
        switch (msg.getType()) {
            case KEEP_ALIVE: {
                return;
            }
            case CHOKE: {
                this.choked = true;
                this.firePeerChoked();
                this.cancelPendingRequests();
                return;
            }
            case UNCHOKE: {
                this.choked = false;
                logger.trace("Peer {} is now accepting requests.", (Object)this);
                this.firePeerReady();
                return;
            }
            case INTERESTED: {
                this.interested = true;
                return;
            }
            case NOT_INTERESTED: {
                this.interested = false;
                return;
            }
            case HAVE: {
                PeerMessage.HaveMessage have = (PeerMessage.HaveMessage)msg;
                Piece havePiece = this.torrent.getPiece(have.getPieceIndex());
                BitSet bitSet = this.availablePieces;
                synchronized (bitSet) {
                    this.availablePieces.set(havePiece.getIndex());
                    logger.trace("Peer {} now has {} [{}/{}].", new Object[]{this, havePiece, this.availablePieces.cardinality(), this.torrent.getPieceCount()});
                }
                this.firePieceAvailabity(havePiece);
                return;
            }
            case BITFIELD: {
                PeerMessage.BitfieldMessage bitfield = (PeerMessage.BitfieldMessage)msg;
                BitSet bitSet = this.availablePieces;
                synchronized (bitSet) {
                    this.availablePieces.or(bitfield.getBitfield());
                    logger.trace("Recorded bitfield from {} with {} pieces(s) [{}/{}].", new Object[]{this, bitfield.getBitfield().cardinality(), this.availablePieces.cardinality(), this.torrent.getPieceCount()});
                }
                this.fireBitfieldAvailabity();
                return;
            }
            case REQUEST: {
                PeerMessage.RequestMessage request = (PeerMessage.RequestMessage)msg;
                Piece rp = this.torrent.getPiece(request.getPiece());
                if (this.isChoking() || !rp.isValid()) {
                    logger.warn("Peer {} violated protocol, terminating exchange.", (Object)this);
                    this.unbind(true);
                    return;
                }
                if (request.getLength() > 131072) {
                    logger.warn("Peer {} requested a block too big, terminating exchange.", (Object)this);
                    this.unbind(true);
                    return;
                }
                try {
                    ByteBuffer block = rp.read(request.getOffset(), request.getLength());
                    this.send(PeerMessage.PieceMessage.craft(request.getPiece(), request.getOffset(), block));
                    this.upload.add(block.capacity());
                    if ((long)(request.getOffset() + request.getLength()) != rp.size()) return;
                    this.firePieceSent(rp);
                    return;
                }
                catch (IOException ioe) {
                    this.fireIOException(new IOException("Error while sending piece block request!", ioe));
                }
                return;
            }
            case PIECE: {
                PeerMessage.PieceMessage piece = (PeerMessage.PieceMessage)msg;
                Piece p = this.torrent.getPiece(piece.getPiece());
                this.removeBlockRequest(piece);
                this.download.add(piece.getBlock().capacity());
                try {
                    Piece piece2 = p;
                    synchronized (piece2) {
                        if (p.isValid()) {
                            this.requestedPiece = null;
                            this.cancelPendingRequests();
                            this.firePeerReady();
                            logger.debug("Discarding block for already completed " + p);
                            return;
                        }
                        p.record(piece.getBlock(), piece.getOffset());
                        if ((long)(piece.getOffset() + piece.getBlock().capacity()) == p.size()) {
                            p.validate();
                            this.firePieceCompleted(p);
                            this.requestedPiece = null;
                            this.firePeerReady();
                        } else {
                            this.requestNextBlocks();
                        }
                        return;
                    }
                }
                catch (IOException ioe) {
                    this.fireIOException(new IOException("Error while storing received piece block!", ioe));
                }
                return;
            }
        }
    }

    private void firePeerChoked() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePeerChoked(this);
        }
    }

    private void firePeerReady() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePeerReady(this);
        }
    }

    private void firePieceAvailabity(Piece piece) {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePieceAvailability(this, piece);
        }
    }

    private void fireBitfieldAvailabity() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handleBitfieldAvailability(this, this.getAvailablePieces());
        }
    }

    private void firePieceSent(Piece piece) {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePieceSent(this, piece);
        }
    }

    private void firePieceCompleted(Piece piece) throws IOException {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePieceCompleted(this, piece);
        }
    }

    private void firePeerDisconnected() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePeerDisconnected(this);
        }
    }

    private void fireIOException(IOException ioe) {
        for (PeerActivityListener listener : this.listeners) {
            listener.handleIOException(this, ioe);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [" + (this.choked ? "C" : "c") + (this.interested ? "I" : "i") + "|" + (this.choking ? "C" : "c") + (this.interesting ? "I" : "i") + "|" + this.availablePieces.cardinality() + "]";
    }

    public static class ULRateComparator
    implements Comparator<SharingPeer>,
    Serializable {
        private static final long serialVersionUID = 38794949747717L;

        @Override
        public int compare(SharingPeer a, SharingPeer b) {
            return Rate.RATE_COMPARATOR.compare(a.getULRate(), b.getULRate());
        }
    }

    public static class DLRateComparator
    implements Comparator<SharingPeer>,
    Serializable {
        private static final long serialVersionUID = 96307229964730L;

        @Override
        public int compare(SharingPeer a, SharingPeer b) {
            return Rate.RATE_COMPARATOR.compare(a.getDLRate(), b.getDLRate());
        }
    }
}

