/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol.udp;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.udp.UDPAnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.udp.UDPAnnounceResponseMessage;
import com.turn.ttorrent.common.protocol.udp.UDPConnectRequestMessage;
import com.turn.ttorrent.common.protocol.udp.UDPConnectResponseMessage;
import com.turn.ttorrent.common.protocol.udp.UDPTrackerErrorMessage;
import java.nio.ByteBuffer;

public abstract class UDPTrackerMessage
extends TrackerMessage {
    private UDPTrackerMessage(TrackerMessage.Type type, ByteBuffer data) {
        super(type, data);
    }

    public abstract int getActionId();

    public abstract int getTransactionId();

    public static abstract class UDPTrackerResponseMessage
    extends UDPTrackerMessage {
        private static final int UDP_MIN_RESPONSE_PACKET_SIZE = 8;

        protected UDPTrackerResponseMessage(TrackerMessage.Type type, ByteBuffer data) {
            super(type, data);
        }

        public static UDPTrackerResponseMessage parse(ByteBuffer data) throws TrackerMessage.MessageValidationException {
            if (data.remaining() < 8) {
                throw new TrackerMessage.MessageValidationException("Invalid packet size!");
            }
            data.mark();
            int action = data.getInt();
            data.reset();
            if (action == TrackerMessage.Type.CONNECT_RESPONSE.getId()) {
                return UDPConnectResponseMessage.parse(data);
            }
            if (action == TrackerMessage.Type.ANNOUNCE_RESPONSE.getId()) {
                return UDPAnnounceResponseMessage.parse(data);
            }
            if (action == TrackerMessage.Type.ERROR.getId()) {
                return UDPTrackerErrorMessage.parse(data);
            }
            throw new TrackerMessage.MessageValidationException("Unknown UDP tracker response message!");
        }
    }

    public static abstract class UDPTrackerRequestMessage
    extends UDPTrackerMessage {
        private static final int UDP_MIN_REQUEST_PACKET_SIZE = 16;

        protected UDPTrackerRequestMessage(TrackerMessage.Type type, ByteBuffer data) {
            super(type, data);
        }

        public static UDPTrackerRequestMessage parse(ByteBuffer data) throws TrackerMessage.MessageValidationException {
            if (data.remaining() < 16) {
                throw new TrackerMessage.MessageValidationException("Invalid packet size!");
            }
            data.mark();
            data.getLong();
            int action = data.getInt();
            data.reset();
            if (action == TrackerMessage.Type.CONNECT_REQUEST.getId()) {
                return UDPConnectRequestMessage.parse(data);
            }
            if (action == TrackerMessage.Type.ANNOUNCE_REQUEST.getId()) {
                return UDPAnnounceRequestMessage.parse(data);
            }
            throw new TrackerMessage.MessageValidationException("Unknown UDP tracker request message!");
        }
    }
}

