/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;

public class ImplHessianBlobIntensity {
    public static void determinant(ImageFloat32 featureIntensity, ImageFloat32 hessianXX, ImageFloat32 hessianYY, ImageFloat32 hessianXY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new ImageFloat32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexXY = hessianXY.startIndex + y * hessianXY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                float dxx = hessianXX.data[indexXX++];
                float dyy = hessianYY.data[indexYY++];
                float dxy = hessianXY.data[indexXY++];
                featureIntensity.data[indexInten++] = dxx * dyy - dxy * dxy;
            }
        }
    }

    public static void trace(ImageFloat32 featureIntensity, ImageFloat32 hessianXX, ImageFloat32 hessianYY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new ImageFloat32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                float dxx = hessianXX.data[indexXX++];
                float dyy = hessianYY.data[indexYY++];
                featureIntensity.data[indexInten++] = dxx + dyy;
            }
        }
    }

    public static void determinant(ImageFloat32 featureIntensity, ImageSInt16 hessianXX, ImageSInt16 hessianYY, ImageSInt16 hessianXY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new ImageFloat32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexXY = hessianXY.startIndex + y * hessianXY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                short dxx = hessianXX.data[indexXX++];
                short dyy = hessianYY.data[indexYY++];
                short dxy = hessianXY.data[indexXY++];
                featureIntensity.data[indexInten++] = dxx * dyy - dxy * dxy;
            }
        }
    }

    public static void trace(ImageFloat32 featureIntensity, ImageSInt16 hessianXX, ImageSInt16 hessianYY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new ImageFloat32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                short dxx = hessianXX.data[indexXX++];
                short dyy = hessianYY.data[indexYY++];
                featureIntensity.data[indexInten++] = dxx + dyy;
            }
        }
    }
}

