/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationIntegralBase;
import boofcv.factory.transform.ii.FactorySparseIntegralFilters;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sparse.GradientValue;
import boofcv.struct.sparse.SparseScaleSample_F64;

public class ImplOrientationImageAverageIntegral<T extends ImageSingleBand, G extends GradientValue>
extends OrientationIntegralBase<T, G> {
    protected Kernel2D_F64 kerCosine;
    protected Kernel2D_F64 kerSine;
    private SparseScaleSample_F64<T> sampler;

    public ImplOrientationImageAverageIntegral(int radius, double period, int sampleWidth, double weightSigma, Class<T> imageType) {
        super(radius, period, sampleWidth, weightSigma, imageType);
        int w = radius * 2 + 1;
        this.kerCosine = new Kernel2D_F64(w);
        this.kerSine = new Kernel2D_F64(w);
        for (int y = -radius; y <= radius; ++y) {
            int pixelY = y + radius;
            for (int x = -radius; x <= radius; ++x) {
                int pixelX = x + radius;
                float r = (float)Math.sqrt(x * x + y * y);
                this.kerCosine.set(pixelX, pixelY, (double)((float)x / r));
                this.kerSine.set(pixelX, pixelY, (double)((float)y / r));
            }
        }
        this.kerCosine.set(radius, radius, 0.0);
        this.kerSine.set(radius, radius, 0.0);
        this.sampler = FactorySparseIntegralFilters.sample((int)(sampleWidth / 2), imageType);
    }

    @Override
    public void setImage(T integralImage) {
        super.setImage(integralImage);
        this.sampler.setImage(integralImage);
    }

    @Override
    public void setScale(double scale) {
        super.setScale(scale);
        this.sampler.setScale(scale);
    }

    @Override
    public double compute(double c_x, double c_y) {
        double period = this.scale * this.period;
        double tl_x = c_x - (double)this.radius * period;
        double tl_y = c_y - (double)this.radius * period;
        if (this.weights == null) {
            return this.computeUnweighted(tl_x, tl_y, period);
        }
        return this.computeWeighted(tl_x, tl_y, period);
    }

    protected double computeUnweighted(double tl_x, double tl_y, double samplePeriod) {
        tl_x += 0.5;
        tl_y += 0.5;
        double Dx = 0.0;
        double Dy = 0.0;
        int i = 0;
        for (int y = 0; y < this.width; ++y) {
            int pixelY = (int)(tl_y + (double)y * samplePeriod);
            int x = 0;
            while (x < this.width) {
                int pixelX = (int)(tl_x + (double)x * samplePeriod);
                if (this.sampler.isInBounds(pixelX, pixelY)) {
                    try {
                        double val = this.sampler.compute(pixelX, pixelY);
                        Dx += this.kerCosine.data[i] * val;
                        Dy += this.kerSine.data[i] * val;
                    }
                    catch (RuntimeException e) {
                        this.sampler.isInBounds(pixelX, pixelY);
                        this.sampler.compute(pixelX, pixelY);
                        throw e;
                    }
                }
                ++x;
                ++i;
            }
        }
        return Math.atan2(Dy, Dx);
    }

    protected double computeWeighted(double tl_x, double tl_y, double samplePeriod) {
        tl_x += 0.5;
        tl_y += 0.5;
        double Dx = 0.0;
        double Dy = 0.0;
        int i = 0;
        for (int y = 0; y < this.width; ++y) {
            int pixelY = (int)(tl_y + (double)y * samplePeriod);
            int x = 0;
            while (x < this.width) {
                int pixelX = (int)(tl_x + (double)x * samplePeriod);
                if (this.sampler.isInBounds(pixelX, pixelY)) {
                    double val = this.sampler.compute(pixelX, pixelY);
                    double w = this.weights.data[i];
                    Dx += w * this.kerCosine.data[i] * val;
                    Dy += w * this.kerSine.data[i] * val;
                }
                ++x;
                ++i;
            }
        }
        return Math.atan2(Dy, Dx);
    }
}

