/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.struct.feature.TupleDesc;

public class TupleDesc_B
implements TupleDesc<TupleDesc_B> {
    public int[] data;
    public int numBits;

    public TupleDesc_B(int numBits) {
        int numInts = numBits / 32;
        if (numBits % 32 != 0) {
            ++numInts;
        }
        this.numBits = numBits;
        this.data = new int[numInts];
    }

    public TupleDesc_B(int numBits, int numInts) {
        this.numBits = numBits;
        this.data = new int[numInts];
    }

    public boolean isBitTrue(int bit) {
        int index = bit / 32;
        return (this.data[index] >> bit % 32 & 1) == 1;
    }

    @Override
    public TupleDesc_B copy() {
        TupleDesc_B ret = new TupleDesc_B(this.numBits);
        System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
        return ret;
    }

    @Override
    public void setTo(TupleDesc_B source) {
        if (this.data.length < source.data.length) {
            throw new IllegalArgumentException("Data array is too small to store the source array.");
        }
        this.numBits = source.numBits;
        System.arraycopy(source.data, 0, this.data, 0, source.data.length);
    }

    @Override
    public double getDouble(int index) {
        if (this.isBitTrue(index)) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public int size() {
        return this.numBits;
    }
}

