/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.postprocessor;

import adams.flow.core.AbstractActor;
import adams.flow.processor.UpdateEventName;
import adams.flow.standalone.Events;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.flow.tree.postprocessor.AbstractEditPostProcessor;

public class EventRenamed
extends AbstractEditPostProcessor {
    private static final long serialVersionUID = 4776606137570074080L;

    public String globalInfo() {
        return "Updates all references of the event that was renamed.";
    }

    public boolean applies(AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        return parent instanceof Events && !oldActor.getName().equals(newActor.getName());
    }

    public boolean postProcess(Tree tree, AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        boolean result = false;
        UpdateEventName updater = new UpdateEventName();
        updater.setOldName(oldActor.getName());
        updater.setNewName(newActor.getName());
        updater.process(tree.getActor());
        if (updater.isModified()) {
            result = true;
            tree.setModified(true);
            tree.setActor(updater.getModifiedActor());
            tree.notifyActorChangeListeners(new ActorChangeEvent(tree, new Node[0], ActorChangeEvent.Type.MODIFY_BULK));
            tree.refreshTabs();
        }
        return result;
    }
}

