/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import java.util.ArrayList;
import net.semanticmetadata.lire.imageanalysis.mser.BoundaryPixel;
import net.semanticmetadata.lire.imageanalysis.mser.LinkedImagePoint;
import net.semanticmetadata.lire.imageanalysis.mser.MSERGrowthHistory;

public class MSERComponent {
    LinkedImagePoint head = null;
    LinkedImagePoint tail = null;
    MSERGrowthHistory history = null;
    ArrayList<MSERGrowthHistory> historiesToLinkToParent = new ArrayList();
    int greyLevel;
    int size;

    public MSERComponent(int level) {
        this.greyLevel = level;
        this.size = 0;
    }

    public void addPixel(BoundaryPixel pixel) {
        if (this.size == 0) {
            this.tail = this.head = new LinkedImagePoint(pixel.getPoint());
        } else {
            LinkedImagePoint newLast = new LinkedImagePoint(pixel.getPoint());
            newLast.setPrev(this.tail);
            this.tail.setNext(newLast);
            this.tail = newLast;
        }
        ++this.size;
    }

    public void mergeComponents(MSERComponent comp, int newGreyLevel) {
        if (comp.getSize() != 0) {
            if (this.size == 0) {
                this.tail = this.head = comp.getHead();
            } else {
                comp.getHead().setPrev(this.tail);
                this.tail.setNext(comp.getHead());
                this.tail = comp.getTail();
            }
            this.size += comp.getSize();
        }
        if (comp.getHistory() != null) {
            this.historiesToLinkToParent.add(comp.getHistory());
        }
        if (comp.getHistoriesToLinkToParent().size() > 0) {
            this.historiesToLinkToParent.addAll(comp.getHistoriesToLinkToParent());
        }
        this.setGreyLevel(newGreyLevel);
    }

    public void addHistory() {
        MSERGrowthHistory newHist = new MSERGrowthHistory(this.size, this.greyLevel, this.head);
        if (this.history != null) {
            this.history.parent = newHist;
        }
        for (MSERGrowthHistory toAdd : this.historiesToLinkToParent) {
            toAdd.parent = newHist;
        }
        this.historiesToLinkToParent.clear();
        this.history = newHist;
    }

    public MSERGrowthHistory getHistory() {
        return this.history;
    }

    public int getPastSize() {
        if (this.history != null) {
            return this.history.getSize();
        }
        return 0;
    }

    public void setGreyLevel(int currentGreyLevel) {
        this.greyLevel = currentGreyLevel;
    }

    public int getGreyLevel() {
        return this.greyLevel;
    }

    public int getSize() {
        return this.size;
    }

    public LinkedImagePoint getHead() {
        return this.head;
    }

    public LinkedImagePoint getTail() {
        return this.tail;
    }

    public ArrayList<MSERGrowthHistory> getHistoriesToLinkToParent() {
        return this.historiesToLinkToParent;
    }
}

