/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import java.awt.image.BufferedImage;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.mser.MSERGrowthHistory;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class MSERFeature
extends Histogram
implements LireFeature {
    MSERGrowthHistory mser;

    public MSERFeature(MSERGrowthHistory maxStableExtremalRegion, double[] invariants) {
        this.mser = maxStableExtremalRegion;
        this.descriptor = invariants;
    }

    public MSERFeature() {
        this.mser = null;
    }

    @Override
    public void extract(BufferedImage bimg) {
        throw new RuntimeException("Extraction not available here");
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof MSERFeature)) {
            return -1.0f;
        }
        return (float)MetricsUtils.distL2(this.descriptor, ((MSERFeature)feature).descriptor);
    }

    @Override
    public String getStringRepresentation() {
        throw new UnsupportedOperationException("not implemented due to performance issues");
    }

    @Override
    public void setStringRepresentation(String s) {
        throw new UnsupportedOperationException("not implemented due to performance issues");
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.descriptor);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.descriptor = SerializationUtils.toDoubleArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.descriptor = SerializationUtils.toDoubleArray(in, offset, length);
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.descriptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.descriptor.length; ++i) {
            double v = this.descriptor[i];
            sb.append(v);
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public String getFeatureName() {
        return "MSER";
    }

    @Override
    public String getFieldName() {
        return "featureMSER";
    }
}

