/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.sift;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class Feature
extends Histogram
implements Comparable<Feature>,
Serializable,
LireFeature {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public float scale;
    public float orientation;
    public float[] location;

    public Feature() {
    }

    public Feature(float s, float o, float[] l, float[] d) {
        this.scale = s;
        this.orientation = o;
        this.location = l;
        this.descriptor = SerializationUtils.toDoubleArray(d);
    }

    @Override
    public int compareTo(Feature f) {
        return this.scale < f.scale ? 1 : (this.scale == f.scale ? 0 : -1);
    }

    public float descriptorDistance(Feature f) {
        if (!(f instanceof Feature)) {
            return -1.0f;
        }
        return (float)MetricsUtils.distL2(this.descriptor, f.descriptor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.descriptor.length; ++i) {
            sb.append(this.descriptor[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (feature instanceof Feature) {
            return this.descriptorDistance((Feature)feature);
        }
        return -1.0f;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("sift");
        sb.append(' ');
        sb.append(this.scale);
        sb.append(' ');
        sb.append(this.orientation);
        sb.append(' ');
        assert (this.location.length == 2);
        sb.append(this.location[0]);
        sb.append(' ');
        sb.append(this.location[1]);
        sb.append(' ');
        for (int i = 0; i < this.descriptor.length; ++i) {
            sb.append(this.descriptor[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s, " ");
        if (!st.nextToken().equals("sift")) {
            this.logger.warning("This is not a SIFT feature.");
            return;
        }
        this.scale = Float.parseFloat(st.nextToken());
        this.orientation = Float.parseFloat(st.nextToken());
        this.location = new float[2];
        this.location[0] = Float.parseFloat(st.nextToken());
        this.location[1] = Float.parseFloat(st.nextToken());
        LinkedList<Float> descVals = new LinkedList<Float>();
        while (st.hasMoreTokens()) {
            descVals.add(Float.valueOf(Float.parseFloat(st.nextToken())));
        }
        this.descriptor = new double[descVals.size()];
        for (int i = 0; i < this.descriptor.length; ++i) {
            this.descriptor[i] = ((Float)descVals.get(i)).floatValue();
        }
    }

    @Override
    public void extract(BufferedImage bimg) {
        throw new UnsupportedOperationException("No implemented!");
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        int j;
        byte[] result = new byte[this.descriptor.length * 4 + 16];
        byte[] tmp = SerializationUtils.toBytes(this.scale);
        for (j = 0; j < 4; ++j) {
            result[j] = tmp[j];
        }
        tmp = SerializationUtils.toBytes(this.orientation);
        for (j = 0; j < 4; ++j) {
            result[4 + j] = tmp[j];
        }
        tmp = SerializationUtils.toBytes(this.location[0]);
        for (j = 0; j < 4; ++j) {
            result[8 + j] = tmp[j];
        }
        tmp = SerializationUtils.toBytes(this.location[1]);
        for (j = 0; j < 4; ++j) {
            result[12 + j] = tmp[j];
        }
        for (int i = 16; i < result.length; i += 4) {
            tmp = SerializationUtils.toBytes(this.descriptor[(i - 16) / 4]);
            for (int j2 = 0; j2 < 4; ++j2) {
                result[i + j2] = tmp[j2];
            }
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        byte[] tmp = new byte[4];
        this.descriptor = new double[in.length / 4 - 4];
        this.location = new float[2];
        System.arraycopy(in, 0, tmp, 0, 4);
        this.scale = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, 4, tmp, 0, 4);
        this.orientation = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, 8, tmp, 0, 4);
        this.location[0] = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, 12, tmp, 0, 4);
        this.location[1] = SerializationUtils.toFloat(tmp);
        for (int i = 0; i < this.descriptor.length; ++i) {
            System.arraycopy(in, 16 + i * 4, tmp, 0, 4);
            this.descriptor[i] = SerializationUtils.toFloat(tmp);
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        byte[] tmp = new byte[4];
        this.descriptor = new double[length / 4 - 4];
        this.location = new float[2];
        System.arraycopy(in, offset, tmp, 0, 4);
        this.scale = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, offset + 4, tmp, 0, 4);
        this.orientation = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, offset + 8, tmp, 0, 4);
        this.location[0] = SerializationUtils.toFloat(tmp);
        System.arraycopy(in, offset + 12, tmp, 0, 4);
        this.location[1] = SerializationUtils.toFloat(tmp);
        for (int i = 0; i < this.descriptor.length; ++i) {
            System.arraycopy(in, offset + 16 + i * 4, tmp, 0, 4);
            this.descriptor[i] = SerializationUtils.toFloat(tmp);
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        double[] result = new double[this.descriptor.length];
        for (int i = 0; i < this.descriptor.length; ++i) {
            result[i] = this.descriptor[i];
        }
        return result;
    }

    @Override
    public String getFeatureName() {
        return "SIFT";
    }

    @Override
    public String getFieldName() {
        return "featureSift";
    }
}

