/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import net.semanticmetadata.lire.AbstractImageSearcher;
import net.semanticmetadata.lire.ImageDuplicates;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.impl.SimpleImageSearchHits;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.utils.LuceneUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;

public class VisualWordsImageSearcher
extends AbstractImageSearcher {
    private int numMaxHits;
    private String fieldName;
    private Similarity similarity = new BM25Similarity();
    QueryParser qp;

    public VisualWordsImageSearcher(int numMaxHits, Similarity similarity, String fieldName) {
        this.similarity = similarity;
        this.numMaxHits = numMaxHits;
        this.fieldName = fieldName;
        this.qp = new QueryParser(LuceneUtils.LUCENE_VERSION, fieldName, (Analyzer)new WhitespaceAnalyzer(LuceneUtils.LUCENE_VERSION));
        BooleanQuery.setMaxClauseCount((int)10000);
    }

    public VisualWordsImageSearcher(int numMaxHits, String fieldName) {
        this.numMaxHits = numMaxHits;
        this.fieldName = fieldName;
        this.qp = new QueryParser(LuceneUtils.LUCENE_VERSION, fieldName, (Analyzer)new WhitespaceAnalyzer(LuceneUtils.LUCENE_VERSION));
        BooleanQuery.setMaxClauseCount((int)10000);
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        SimpleImageSearchHits sh = null;
        IndexSearcher isearcher = new IndexSearcher(reader);
        isearcher.setSimilarity(this.similarity);
        String queryString = doc.getValues(this.fieldName)[0];
        Query tq = null;
        try {
            tq = this.qp.parse(queryString);
            TopDocs docs = isearcher.search(tq, this.numMaxHits);
            LinkedList<SimpleResult> res = new LinkedList<SimpleResult>();
            float maxDistance = 0.0f;
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                float d = 1.0f / docs.scoreDocs[i].score;
                maxDistance = Math.max(d, maxDistance);
                SimpleResult sr = new SimpleResult(d, reader.document(docs.scoreDocs[i].doc), i);
                res.add(sr);
            }
            sh = new SimpleImageSearchHits(res, maxDistance);
        }
        catch (ParseException e) {
            System.err.println(queryString);
            e.printStackTrace();
        }
        return sh;
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("Not implemented!");
    }

    private static class MySimilarity
    extends DefaultSimilarity {
        private MySimilarity() {
        }

        public float tf(float freq) {
            return 1.0f;
        }

        public float idf(int docfreq, int numdocs) {
            return 1.0f;
        }

        public float queryNorm(float sumOfSquaredWeights) {
            return 1.0f;
        }

        public float computeNorm(String field, FieldInvertState state) {
            return 1.0f;
        }
    }
}

