/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.OptionHandler;
import adams.data.twitter.AbstractTwitterStatusConverter;
import adams.data.twitter.TextConverter;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import twitter4j.Status;

public class TwitterConverter
extends AbstractTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -4249772734326614365L;
    protected AbstractTwitterStatusConverter m_Converter;

    public String globalInfo() {
        return "Turns a Twitter tweet or status into different representation.\nGEO location data might not be available.\nFor more information on the date format, see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return new DateFormat().getTechnicalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("converter", "converter", (Object)new TextConverter());
    }

    public void setConverter(AbstractTwitterStatusConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractTwitterStatusConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The converter to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)((Object)this.m_Converter));
    }

    public Class[] accepts() {
        return new Class[]{Status.class};
    }

    public Class[] generates() {
        if (this.m_Converter != null) {
            return new Class[]{this.m_Converter.generates()};
        }
        return new Class[]{Unknown.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_OutputToken = new Token(this.m_Converter.convert((Status)this.m_InputToken.getPayload()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to process status update!", e);
        }
        return result;
    }
}

