/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.gui.ColorChooser;
import ij.gui.Toolbar;
import ij.plugin.frame.ColorGenerator;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ColorCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    int width;
    int height;
    Vector colors;
    boolean background;
    long mouseDownTime;
    ColorGenerator ip;
    Frame frame;

    public ColorCanvas(int width, int height, Frame frame, ColorGenerator ip) {
        this.width = width;
        this.height = height;
        this.ip = ip;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(IJ.getInstance());
        this.setSize(width, height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        g.drawImage(this.ip.createImage(), 0, 0, null);
    }

    public void mousePressed(MouseEvent e) {
        this.ip.setLineWidth(1);
        if (Toolbar.getToolId() == 13) {
            IJ.setTool(0);
        }
        Rectangle flipperRect = new Rectangle(86, 268, 18, 18);
        Rectangle resetRect = new Rectangle(86, 294, 18, 18);
        Rectangle foreground1Rect = new Rectangle(9, 266, 45, 10);
        Rectangle foreground2Rect = new Rectangle(9, 276, 23, 25);
        Rectangle background1Rect = new Rectangle(33, 302, 45, 10);
        Rectangle background2Rect = new Rectangle(56, 277, 23, 25);
        int x = e.getX();
        int y = e.getY();
        long difference = System.currentTimeMillis() - this.mouseDownTime;
        boolean doubleClick = difference <= 250L;
        this.mouseDownTime = System.currentTimeMillis();
        if (flipperRect.contains(x, y)) {
            Color c = Toolbar.getBackgroundColor();
            Toolbar.setBackgroundColor(Toolbar.getForegroundColor());
            Toolbar.setForegroundColor(c);
        } else if (resetRect.contains(x, y)) {
            Toolbar.setForegroundColor(new Color(0));
            Toolbar.setBackgroundColor(new Color(0xFFFFFF));
        } else if (background1Rect.contains(x, y) || background2Rect.contains(x, y)) {
            this.background = true;
            if (doubleClick) {
                this.editColor();
            }
            this.ip.refreshForeground();
            this.ip.refreshBackground();
        } else if (foreground1Rect.contains(x, y) || foreground2Rect.contains(x, y)) {
            this.background = false;
            if (doubleClick) {
                this.editColor();
            }
            this.ip.refreshBackground();
            this.ip.refreshForeground();
        } else if (doubleClick) {
            this.editColor();
        } else {
            this.setDrawingColor(x, y, this.background);
        }
        if (this.background) {
            this.ip.refreshForeground();
            this.ip.refreshBackground();
        } else {
            this.ip.refreshBackground();
            this.ip.refreshForeground();
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int p = this.ip.getPixel(x, y);
        int r = (p & 0xFF0000) >> 16;
        int g = (p & 0xFF00) >> 8;
        int b = p & 0xFF;
        IJ.showStatus("red=" + this.pad(r) + ", green=" + this.pad(g) + ", blue=" + this.pad(b));
    }

    String pad(int n) {
        String str = "" + n;
        while (str.length() < 3) {
            str = "0" + str;
        }
        return str;
    }

    void setDrawingColor(int x, int y, boolean setBackground) {
        int p = this.ip.getPixel(x, y);
        int r = (p & 0xFF0000) >> 16;
        int g = (p & 0xFF00) >> 8;
        int b = p & 0xFF;
        Color c = new Color(r, g, b);
        if (setBackground) {
            Toolbar.setBackgroundColor(c);
            if (Recorder.record) {
                Recorder.setBackgroundColor(c);
            }
        } else {
            Toolbar.setForegroundColor(c);
            if (Recorder.record) {
                Recorder.setForegroundColor(c);
            }
        }
    }

    void editColor() {
        Color c = this.background ? Toolbar.getBackgroundColor() : Toolbar.getForegroundColor();
        ColorChooser cc = new ColorChooser((this.background ? "Background" : "Foreground") + " Color", c, false);
        c = cc.getColor();
        if (this.background) {
            Toolbar.setBackgroundColor(c);
        } else {
            Toolbar.setForegroundColor(c);
        }
    }

    public void refreshColors() {
        this.ip.refreshBackground();
        this.ip.refreshForeground();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }
}

