/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.PlaceholderFile;
import java.io.File;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDFBox {
    public static PDDocument load(String filename) {
        return PDFBox.load((File)new PlaceholderFile(filename));
    }

    public static PDDocument load(File file) {
        try {
            return PDDocument.load((File)file.getAbsoluteFile());
        }
        catch (Exception e) {
            System.err.println("Failed to load PDF: " + file);
            e.printStackTrace();
            return null;
        }
    }

    public static void close(PDDocument document) {
        if (document != null) {
            try {
                document.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean save(PDDocument doc, String file) {
        return PDFBox.save(doc, (File)new PlaceholderFile(file));
    }

    public static boolean save(PDDocument doc, File file) {
        boolean result;
        try {
            doc.save(file.getAbsoluteFile());
            result = true;
        }
        catch (Exception e) {
            System.err.println("Failed to save PDF document to file '" + file + "':");
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static boolean print(String filename) {
        return PDFBox.print((File)new PlaceholderFile(filename));
    }

    public static boolean print(File file) {
        boolean result = false;
        PDDocument document = PDFBox.load(file);
        if (document != null) {
            result = PDFBox.print(document);
            PDFBox.close(document);
        }
        return result;
    }

    public static boolean print(PDDocument document) {
        try {
            document.print();
            return true;
        }
        catch (Exception e) {
            System.err.println("Failed to print PDF document!");
            e.printStackTrace();
            return false;
        }
    }
}

