/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.AbstractPdfProclet;
import adams.core.io.CsvPdfProclet;
import adams.core.io.FileUtils;
import adams.core.io.ImagePdfProclet;
import adams.core.io.PDFGenerator;
import adams.core.io.PlaceholderFile;
import adams.core.io.PlainTextPdfProclet;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class PDFCreate
extends AbstractTransformer {
    private static final long serialVersionUID = 5783362940767103716L;
    protected PlaceholderFile m_Output;
    protected PDFGenerator.PageSize m_PageSize;
    protected PDFGenerator.PageOrientation m_PageOrientation;
    protected AbstractPdfProclet[] m_Proclets;

    public String globalInfo() {
        return "Actor for generating PDF files. Images (GIF/PNG/JPEG), plain text files and CSV files are supported. CSV files are automatically added as tables (if they contain comments, then these will get added as well).\nThe filename of the generated PDF is forwarded.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("page-size", "pageSize", (Object)PDFGenerator.PageSize.A4);
        this.m_OptionManager.add("page-orientation", "pageOrientation", (Object)PDFGenerator.PageOrientation.PORTRAIT);
        this.m_OptionManager.add("proclet", "proclets", (Object)new AbstractPdfProclet[]{new PlainTextPdfProclet(), new CsvPdfProclet(), new ImagePdfProclet()});
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The PDF file to generate.";
    }

    public void setPageSize(PDFGenerator.PageSize value) {
        this.m_PageSize = value;
        this.reset();
    }

    public PDFGenerator.PageSize getPageSize() {
        return this.m_PageSize;
    }

    public String pageSizeTipText() {
        return "The page size of the generated PDF.";
    }

    public void setPageOrientation(PDFGenerator.PageOrientation value) {
        this.m_PageOrientation = value;
        this.reset();
    }

    public PDFGenerator.PageOrientation getPageOrientation() {
        return this.m_PageOrientation;
    }

    public String pageOrientationTipText() {
        return "The page orientation of the generated PDF.";
    }

    public void setProclets(AbstractPdfProclet[] value) {
        this.m_Proclets = value;
        this.reset();
    }

    public AbstractPdfProclet[] getProclets() {
        return this.m_Proclets;
    }

    public String procletsTipText() {
        return "The processors for processing the files.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"output", (Object)this.m_Output);
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        PlaceholderFile[] files = FileUtils.toPlaceholderFileArray((Object)this.m_InputToken.getPayload());
        PDFGenerator generator = new PDFGenerator();
        generator.setOutput(this.getOutput());
        generator.setPageSize(this.getPageSize());
        generator.setPageOrientation(this.getPageOrientation());
        generator.setProclets(this.getProclets());
        try {
            generator.open();
            for (PlaceholderFile file : files) {
                try {
                    generator.addFile((File)file);
                }
                catch (Exception e) {
                    this.handleException("Problems adding file '" + file + "'!", e);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to create PDF: " + this.m_Output, e);
        }
        finally {
            generator.close();
        }
        this.m_OutputToken = new Token((Object)this.m_Output.getAbsolutePath());
        return result;
    }
}

