/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.feature.detect.quadblob.QuadBlob;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ConnectGridSquares {
    public static List<QuadBlob> pruneSmallIslands(List<QuadBlob> blobs) {
        blobs = new ArrayList<QuadBlob>(blobs);
        List<QuadBlob> largest = new ArrayList<QuadBlob>();
        while (blobs.size() > 0) {
            List<QuadBlob> c = ConnectGridSquares.findIsland(blobs.remove(0), blobs);
            if (c.size() <= largest.size()) continue;
            largest = c;
        }
        return largest;
    }

    public static List<QuadBlob> findIsland(QuadBlob seed, List<QuadBlob> all) {
        ArrayList<QuadBlob> ret = new ArrayList<QuadBlob>();
        Stack<QuadBlob> open = new Stack<QuadBlob>();
        ret.add(seed);
        open.push(seed);
        while (open.size() > 0) {
            QuadBlob s = (QuadBlob)open.pop();
            for (QuadBlob c : s.conn) {
                if (ret.contains(c)) continue;
                all.remove(c);
                ret.add(c);
                open.add(c);
            }
        }
        return ret;
    }

    public static void connect(List<QuadBlob> blobs, double spaceToSquareRatio) {
        for (int i = 0; i < blobs.size(); ++i) {
            QuadBlob b = blobs.get(i);
            for (int j = 0; j < 4; ++j) {
                Point2D_I32 c0 = b.corners.get(j);
                Point2D_I32 c1 = b.corners.get((j + 1) % 4);
                Point2D_I32 c2 = b.corners.get((j + 2) % 4);
                Point2D_I32 c3 = b.corners.get((j + 3) % 4);
                double bestDistance = Math.max(2.0, b.largestSide * 0.2);
                QuadBlob bestQuad = null;
                for (int k = i + 1; k < blobs.size(); ++k) {
                    QuadBlob candidate = blobs.get(k);
                    double d = ConnectGridSquares.predictedDistance(c0, c1, c2, c3, candidate, spaceToSquareRatio);
                    if (Double.isNaN(d) || !(d < bestDistance)) continue;
                    bestDistance = d;
                    bestQuad = candidate;
                }
                if (bestQuad == null) continue;
                bestQuad.conn.add(b);
                b.conn.add(bestQuad);
            }
        }
    }

    private static double predictedDistance(Point2D_I32 a0, Point2D_I32 a1, Point2D_I32 a2, Point2D_I32 a3, QuadBlob b, double spaceToSquareRatio) {
        double actualSpace;
        double total = 0.0;
        Point2D_I32 b0 = ConnectGridSquares.findClosest(a0, a1, b);
        Point2D_I32 b1 = ConnectGridSquares.findClosest(a1, a0, b);
        total += Math.abs(a0.distance(a1) - b0.distance(b1));
        double predictedSpace = spaceToSquareRatio * a0.distance(a1);
        if (Math.abs(predictedSpace - (actualSpace = (a0.distance(b0) + a1.distance(b1)) / 2.0)) / predictedSpace > 0.6) {
            return Double.NaN;
        }
        total += Math.abs(predictedSpace - actualSpace);
        Point2D_I32 predB0 = new Point2D_I32(b0.x + a0.x - a3.x, b0.y + a0.y - a3.y);
        Point2D_I32 predB1 = new Point2D_I32(b1.x + a1.x - a2.x, b1.y + a1.y - a2.y);
        Point2D_I32 b2 = ConnectGridSquares.findClosest(predB1, predB0, b);
        Point2D_I32 b3 = ConnectGridSquares.findClosest(predB0, predB1, b);
        total += Math.abs(a2.distance(a3) - b2.distance(b3));
        total += Math.abs(a0.distance(a3) - b0.distance(b3));
        return (total += Math.abs(a1.distance(a2) - b1.distance(b2))) / 5.0;
    }

    private static Point2D_I32 findClosest(Point2D_I32 a0, Point2D_I32 a1, QuadBlob blob) {
        double best = Double.MAX_VALUE;
        Point2D_I32 bestPoint = null;
        for (int i = 0; i < 4; ++i) {
            double d = a0.distance(blob.corners.get(i));
            double d1 = a1.distance(blob.corners.get(i));
            if (!((d -= d1) < best)) continue;
            best = d;
            bestPoint = blob.corners.get(i);
        }
        return bestPoint;
    }

    public static List<QuadBlob> copy(List<QuadBlob> input) {
        ArrayList<QuadBlob> output = new ArrayList<QuadBlob>();
        for (QuadBlob i : input) {
            QuadBlob o = new QuadBlob();
            o.contour = i.contour;
            o.corners = i.corners;
            o.center = i.center;
            o.largestSide = i.largestSide;
            o.smallestSide = i.smallestSide;
            output.add(o);
        }
        for (int index = 0; index < input.size(); ++index) {
            QuadBlob in = input.get(index);
            QuadBlob out = (QuadBlob)output.get(index);
            for (QuadBlob c : in.conn) {
                int i = input.indexOf(c);
                if (i < 0) continue;
                out.conn.add((QuadBlob)output.get(i));
            }
        }
        return output;
    }
}

