/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.feature.detect.InvalidCalibrationTarget;
import boofcv.alg.feature.detect.grid.ConnectGridSquares;
import boofcv.alg.feature.detect.quadblob.DetectQuadBlobsBinary;
import boofcv.alg.feature.detect.quadblob.OrderPointsIntoGrid;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;

public class DetectSquareCalibrationPoints {
    private ImageUInt8 binaryA = new ImageUInt8(1, 1);
    private ImageUInt8 binaryB = new ImageUInt8(1, 1);
    DetectQuadBlobsBinary detectBlobs;
    private List<QuadBlob> squares;
    private int numSquares;
    private int numBlackCols;
    private int numBlackRows;
    private double relativeSizeThreshold;
    private String errorMessage;
    OrderPointsIntoGrid orderAlg = new OrderPointsIntoGrid();
    List<Point2D_F64> interestPoints;
    private List<QuadBlob> interestSquares = new ArrayList<QuadBlob>();
    private double spaceToSquareRatio;

    public DetectSquareCalibrationPoints(double relativeSizeThreshold, double spaceToSquareRatio, int gridCols, int gridRows) {
        if (gridCols <= 0 || gridRows <= 0) {
            throw new IllegalArgumentException("Columns and rows must be more than zero");
        }
        if (gridCols % 2 == 0 || gridRows % 2 == 0) {
            throw new IllegalArgumentException("Number of columns and rows must be odd");
        }
        this.numBlackRows = gridRows / 2 + 1;
        this.numBlackCols = gridCols / 2 + 1;
        this.spaceToSquareRatio = spaceToSquareRatio;
        this.numSquares = this.numBlackRows * this.numBlackCols;
        this.relativeSizeThreshold = relativeSizeThreshold;
        this.detectBlobs = new DetectQuadBlobsBinary(0, 0.25, this.numSquares);
    }

    public boolean process(ImageUInt8 thresholded) {
        this.interestPoints = new ArrayList<Point2D_F64>();
        this.interestSquares = new ArrayList<QuadBlob>();
        int contourSize = (int)(this.relativeSizeThreshold * 30.0 / 640.0 * (double)thresholded.width);
        this.detectBlobs.setMinContourSize(contourSize);
        this.binaryA.reshape(thresholded.width, thresholded.height);
        this.binaryB.reshape(thresholded.width, thresholded.height);
        BinaryImageOps.erode8((ImageUInt8)thresholded, (int)1, (ImageUInt8)this.binaryA);
        BinaryImageOps.erode8((ImageUInt8)this.binaryA, (int)1, (ImageUInt8)this.binaryB);
        BinaryImageOps.dilate8((ImageUInt8)this.binaryB, (int)1, (ImageUInt8)this.binaryA);
        BinaryImageOps.dilate8((ImageUInt8)this.binaryA, (int)1, (ImageUInt8)this.binaryB);
        if (!this.detectBlobs.process(this.binaryB)) {
            return this.fail(this.detectBlobs.getMessage());
        }
        this.squares = this.detectBlobs.getDetected();
        ConnectGridSquares.connect(this.squares, this.spaceToSquareRatio);
        List<QuadBlob> squaresPruned = ConnectGridSquares.pruneSmallIslands(this.squares);
        if (this.findTargetByAssumption(squaresPruned, this.interestSquares)) {
            this.computeInterestPoints(this.interestSquares);
            return true;
        }
        this.interestSquares.addAll(squaresPruned);
        return false;
    }

    private boolean findTargetByAssumption(List<QuadBlob> squares, List<QuadBlob> targetSquares) {
        if (squares.size() < this.numSquares) {
            return this.fail("Not enough blobs detected");
        }
        targetSquares.clear();
        for (int i = 0; i < squares.size(); ++i) {
            QuadBlob seed = squares.get(i);
            if (!this.constructTarget(seed, targetSquares)) continue;
            return true;
        }
        return false;
    }

    private boolean constructTarget(QuadBlob seed, List<QuadBlob> targetSquares) {
        int i;
        if (seed.conn.size() < 2) {
            return false;
        }
        targetSquares.clear();
        ArrayList<QuadBlob> firstRow = new ArrayList<QuadBlob>();
        QuadBlob nextRow = null;
        for (int i2 = 0; i2 < seed.conn.size(); ++i2) {
            if (!this.findLine(seed, seed.conn.get(i2), firstRow, this.numBlackCols)) continue;
            nextRow = seed.conn.get(i2);
            break;
        }
        if (nextRow == null) {
            return false;
        }
        double angleDown = this.findDownDirection(seed, nextRow);
        if (Double.isNaN(angleDown)) {
            return false;
        }
        ArrayList[] columns = new ArrayList[this.numBlackCols];
        for (int i3 = 0; i3 < this.numBlackCols; ++i3) {
            columns[i3] = new ArrayList();
        }
        SelectResult columnResult = new SelectResult();
        for (i = 0; i < firstRow.size(); ++i) {
            QuadBlob right;
            QuadBlob target = (QuadBlob)firstRow.get(i);
            QuadBlob left = i > 0 ? (QuadBlob)firstRow.get(i - 1) : (QuadBlob)firstRow.get(i);
            QuadBlob quadBlob = right = i < firstRow.size() - 1 ? (QuadBlob)firstRow.get(i + 1) : (QuadBlob)firstRow.get(i);
            if (!this.selectDown(target, left, right, angleDown, columnResult)) {
                return false;
            }
            angleDown = columnResult.angle;
            if (this.findLine(target, columnResult.quad, columns[i], this.numBlackRows)) continue;
            return false;
        }
        for (i = 0; i < this.numBlackRows; ++i) {
            for (int j = 0; j < this.numBlackCols; ++j) {
                targetSquares.add((QuadBlob)columns[j].get(i));
            }
        }
        return true;
    }

    private double findDownDirection(QuadBlob pivot, QuadBlob next) {
        double angle0 = UtilAngle.bound((double)(this.angleQuad(pivot, next) + 1.5707963267948966));
        double bestAcute = 0.6;
        double bestAngle = Double.NaN;
        QuadBlob bestQuad = null;
        for (int i = 0; i < pivot.conn.size(); ++i) {
            QuadBlob q = pivot.conn.get(i);
            double angle1 = this.angleQuad(pivot, q);
            double acute = UtilAngle.distHalf((double)angle0, (double)angle1);
            if (!(acute < bestAcute)) continue;
            bestAcute = acute;
            bestAngle = angle1;
            bestQuad = q;
        }
        if (bestQuad == null) {
            return Double.NaN;
        }
        return bestAngle;
    }

    private boolean findLine(QuadBlob seed1, QuadBlob seed2, List<QuadBlob> line, int numExpected) {
        line.clear();
        line.add(seed1);
        line.add(seed2);
        SelectResult result = new SelectResult();
        double angle = this.angleQuad(seed1, seed2);
        while (this.selectNexInLine(seed2, angle, result) && result.distance < 0.3) {
            line.add(result.quad);
            seed2 = result.quad;
            angle = result.angle;
        }
        return line.size() == numExpected;
    }

    private double angleQuad(QuadBlob seed1, QuadBlob seed2) {
        return Math.atan2(seed2.center.y - seed1.center.y, seed2.center.x - seed1.center.x);
    }

    private boolean selectNexInLine(QuadBlob seed1, double angleTarget, SelectResult result) {
        QuadBlob bestN = null;
        double bestDistance = Double.MAX_VALUE;
        double bestAngle = -1.0;
        for (int i = 0; i < seed1.conn.size(); ++i) {
            QuadBlob n = seed1.conn.get(i);
            double angle2 = this.angleQuad(seed1, n);
            double d = UtilAngle.dist((double)angleTarget, (double)angle2);
            if (!(d < bestDistance)) continue;
            bestN = n;
            bestDistance = d;
            bestAngle = angle2;
        }
        if (bestN == null || bestDistance > 0.4) {
            return false;
        }
        result.distance = bestDistance;
        result.quad = bestN;
        result.angle = bestAngle;
        return true;
    }

    private boolean selectDown(QuadBlob target, QuadBlob conn1, QuadBlob conn2, double angle, SelectResult result) {
        QuadBlob bestN = null;
        double bestDistance = 0.6;
        double bestAngle = -1.0;
        for (QuadBlob c : target.conn) {
            double angle2;
            double d;
            if (c == conn1 || c == conn2 || !((d = UtilAngle.dist((double)angle, (double)(angle2 = this.angleQuad(target, c)))) < bestDistance)) continue;
            bestN = c;
            bestDistance = d;
            bestAngle = angle2;
        }
        if (bestN == null) {
            return false;
        }
        result.distance = bestDistance;
        result.quad = bestN;
        result.angle = bestAngle;
        return true;
    }

    private boolean computeInterestPoints(List<QuadBlob> list) {
        try {
            this.interestPoints = new ArrayList<Point2D_F64>();
            for (QuadBlob b : list) {
                for (Point2D_I32 c : b.corners) {
                    this.interestPoints.add(new Point2D_F64((double)c.x, (double)c.y));
                }
            }
            this.interestSquares = list;
            this.orderAlg.process(this.interestPoints);
            this.interestPoints = this.orderAlg.getOrdered();
            return true;
        }
        catch (InvalidCalibrationTarget invalidCalibrationTarget) {
            return false;
        }
    }

    public List<Point2D_F64> getTargetQuadrilateral() {
        return this.orderAlg.getQuadrilateral();
    }

    private boolean fail(String message) {
        this.errorMessage = message;
        return false;
    }

    public ImageSInt32 getBlobs() {
        return this.detectBlobs.getLabeledImage();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<QuadBlob> getAllSquares() {
        return this.squares;
    }

    public List<QuadBlob> getInterestSquares() {
        return this.interestSquares;
    }

    public List<Point2D_F64> getInterestPoints() {
        return this.interestPoints;
    }

    public List<QuadBlob> getSquaresBad() {
        return this.detectBlobs.getInvalid();
    }

    public int getNumberOfLabels() {
        return this.detectBlobs.getNumLabels();
    }

    public DetectQuadBlobsBinary getDetectBlobs() {
        return this.detectBlobs;
    }

    private static class SelectResult {
        QuadBlob quad;
        double distance;
        double angle;

        private SelectResult() {
        }
    }
}

