/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.tasks.TaskMonitor;

public class CusumDM
extends AbstractChangeDetector {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "The minimum number of instances before permitting detecting change.", 30, 0, Integer.MAX_VALUE);
    public FloatOption deltaOption = new FloatOption("delta", 'd', "Delta parameter of the Cusum Test", 0.005, 0.0, 1.0);
    public FloatOption lambdaOption = new FloatOption("lambda", 'l', "Threshold parameter of the Cusum Test", 50.0, 0.0, 3.4028234663852886E38);
    private int m_n;
    private double sum;
    private double x_mean;
    private double alpha;
    private double delta;
    private double lambda;

    public CusumDM() {
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        this.m_n = 1;
        this.x_mean = 0.0;
        this.sum = 0.0;
        this.delta = this.deltaOption.getValue();
        this.lambda = this.lambdaOption.getValue();
    }

    @Override
    public void input(double x) {
        if (this.isChangeDetected || !this.isInitialized) {
            this.resetLearning();
            this.isInitialized = true;
        }
        this.x_mean += (x - this.x_mean) / (double)this.m_n;
        this.sum = Math.max(0.0, this.sum + x - this.x_mean - this.delta);
        ++this.m_n;
        this.estimation = this.x_mean;
        this.isChangeDetected = false;
        this.isWarningZone = false;
        this.delay = 0.0;
        if (this.m_n < this.minNumInstancesOption.getValue()) {
            return;
        }
        if (this.sum > this.lambda) {
            this.isChangeDetected = true;
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

