/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core;

import java.util.Arrays;
import java.util.LinkedList;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.FIMTDDNumericAttributeClassObserver;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.classifiers.rules.AMRulesRegressor;
import moa.classifiers.rules.AbstractAMRules;
import moa.classifiers.rules.core.Rule;
import moa.classifiers.rules.core.RuleActiveLearningNode;
import moa.classifiers.rules.core.splitcriteria.SDRSplitCriterionAMRules;
import moa.classifiers.rules.functions.Perceptron;
import moa.classifiers.rules.functions.TargetMean;
import moa.core.DoubleVector;
import weka.core.Instance;

public class RuleActiveRegressionNode
extends RuleActiveLearningNode {
    private static final long serialVersionUID = 1607453624545272049L;
    protected Perceptron perceptron;
    protected TargetMean targetMean;

    public Perceptron getPerceptron() {
        return this.perceptron;
    }

    public void setPerceptron(Perceptron perceptron) {
        this.perceptron = perceptron;
    }

    public TargetMean getTargetMean() {
        return this.targetMean;
    }

    public void setTargetMean(TargetMean targetMean) {
        this.targetMean = targetMean;
    }

    public RuleActiveRegressionNode(double[] initialClassObservations) {
        super(initialClassObservations);
    }

    public RuleActiveRegressionNode() {
        this(new double[0]);
    }

    public RuleActiveRegressionNode(Rule.Builder builder) {
        super(builder);
        this.perceptron = new Perceptron();
        this.perceptron.prepareForUse();
        this.perceptron.learningRatioOption = ((AMRulesRegressor)this.amRules).learningRatioOption;
        this.perceptron.constantLearningRatioDecayOption = ((AMRulesRegressor)this.amRules).constantLearningRatioDecayOption;
        if (this.predictionFunction != 1) {
            this.targetMean = new TargetMean();
            if (builder.statistics[0] > 0.0) {
                this.targetMean.reset(builder.statistics[1] / builder.statistics[0], (long)builder.statistics[0]);
            }
        }
        this.predictionFunction = builder.predictionFunction;
        if (builder.statistics != null) {
            this.nodeStatistics = new DoubleVector(builder.statistics);
        }
    }

    @Override
    public void updateStatistics(Instance instance) {
        super.updateStatistics(instance);
        this.perceptron.trainOnInstance(instance);
        if (this.predictionFunction != 1) {
            this.targetMean.trainOnInstance(instance);
        }
    }

    @Override
    public double[] getPrediction(Instance instance, int predictionMode) {
        double[] ret = new double[1];
        ret = predictionMode == 1 ? this.perceptron.getVotesForInstance(instance) : this.targetMean.getVotesForInstance(instance);
        return ret;
    }

    public double getNormalizedPrediction(Instance instance) {
        double res;
        switch (this.predictionFunction) {
            case 1: {
                res = this.perceptron.normalizedPrediction(instance);
                break;
            }
            case 2: {
                double[] aux = this.targetMean.getVotesForInstance(null);
                res = this.normalize(aux[0]);
                break;
            }
            case 0: {
                int predictionMode = this.getLearnerToUse(instance, 0);
                if (predictionMode == 1) {
                    res = this.perceptron.normalizedPrediction(instance);
                    break;
                }
                double[] aux = this.targetMean.getVotesForInstance(instance);
                res = this.normalize(aux[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Prediction mode not in range.");
            }
        }
        return res;
    }

    @Override
    public int getLearnerToUse(Instance instance, int predMode) {
        int predictionMode = predMode;
        if (predictionMode == 0) {
            double perceptronError = this.perceptron.getCurrentError();
            double meanTargetError = this.targetMean.getCurrentError();
            this.debug("\n Check P:" + perceptronError + " M:" + meanTargetError, 5);
            this.debug("Rule" + this.owner.ruleNumberID + " P:" + this.perceptron.getVotesForInstance(instance)[0] + " (" + perceptronError + ")" + " M:" + this.targetMean.getVotesForInstance(instance)[0] + " (" + meanTargetError + ")", 3);
            this.debug("Observed Value: " + instance.classValue(), 5);
            predictionMode = perceptronError < meanTargetError ? 1 : 2;
        }
        return predictionMode;
    }

    private double normalize(double value) {
        double meanY = this.nodeStatistics.getValue(1) / this.nodeStatistics.getValue(0);
        double sdY = this.computeSD(this.nodeStatistics.getValue(2), this.nodeStatistics.getValue(1), (long)this.nodeStatistics.getValue(0));
        double normalizedY = 0.0;
        if (sdY > 1.0E-7) {
            normalizedY = (value - meanY) / sdY;
        }
        return normalizedY;
    }

    public double computeSD(double squaredVal, double val, long size) {
        if (size > 1L) {
            return Math.sqrt((squaredVal - val * val / (double)size) / ((double)size - 1.0));
        }
        return 0.0;
    }

    @Override
    public double computeError(Instance instance) {
        double normalizedPrediction = this.getNormalizedPrediction(instance);
        double normalizedClassValue = this.normalize(instance.classValue());
        return Math.abs(normalizedClassValue - normalizedPrediction);
    }

    @Override
    public boolean isAnomaly(Instance instance, double uniVariateAnomalyProbabilityThreshold, double multiVariateAnomalyProbabilityThreshold, int numberOfInstanceesForAnomaly) {
        long perceptronIntancesSeen = this.perceptron.getInstancesSeen();
        if (perceptronIntancesSeen >= (long)numberOfInstanceesForAnomaly) {
            double atribSum = 0.0;
            double atribSquredSum = 0.0;
            double D = 0.0;
            double N = 0.0;
            double anomaly = 0.0;
            for (int x = 0; x < instance.numAttributes() - 1; ++x) {
                double sd;
                int instAttIndex = AMRulesRegressor.modelAttIndexToInstanceAttIndex(x, instance);
                atribSum = this.perceptron.perceptronattributeStatistics.getValue(x);
                double mean = atribSum / (double)perceptronIntancesSeen;
                double probability = this.computeProbability(mean, sd = this.computeSD(atribSquredSum = this.perceptron.squaredperceptronattributeStatistics.getValue(x), atribSum, perceptronIntancesSeen), instance.value(instAttIndex));
                if (probability > 0.0) {
                    D += Math.abs(Math.log(probability));
                    if (!(probability < uniVariateAnomalyProbabilityThreshold)) continue;
                    N += Math.abs(Math.log(probability));
                    continue;
                }
                this.debug("Anomaly with probability 0 in atribute : " + x, 4);
            }
            anomaly = 0.0;
            if (D != 0.0) {
                anomaly = N / D;
            }
            if (anomaly >= multiVariateAnomalyProbabilityThreshold) {
                this.debuganomaly(instance, uniVariateAnomalyProbabilityThreshold, multiVariateAnomalyProbabilityThreshold, anomaly);
                return true;
            }
        }
        return false;
    }

    protected void debuganomaly(Instance instance, double uni, double multi, double probability) {
        double atribSum = 0.0;
        double atribSquredSum = 0.0;
        for (int x = 0; x < instance.numAttributes() - 1; ++x) {
            int instAttIndex = AMRulesRegressor.modelAttIndexToInstanceAttIndex(x, instance);
            atribSum = this.perceptron.perceptronattributeStatistics.getValue(x);
            atribSquredSum = this.perceptron.squaredperceptronattributeStatistics.getValue(x);
            double mean = atribSum / (double)this.perceptron.getInstancesSeen();
            double sd = this.computeSD(atribSquredSum, atribSum, this.perceptron.getInstancesSeen());
            this.debug("Attribute : " + x, 5);
            this.debug("Value : " + instance.value(instAttIndex), 5);
            this.debug("Mean : " + mean, 5);
            this.debug("SD : " + sd, 5);
            this.debug("Probability : " + probability, 5);
            this.debug("Univariate : " + uni, 5);
            this.debug("Multivariate : " + multi, 5);
            this.debug("Anomaly in rule :" + this.owner.ruleNumberID, 5);
        }
    }

    @Override
    public void initialize(RuleActiveLearningNode oldLearningNode) {
        if (((RuleActiveRegressionNode)oldLearningNode).perceptron != null) {
            this.perceptron = new Perceptron(((RuleActiveRegressionNode)oldLearningNode).perceptron);
            this.perceptron.resetError();
            this.perceptron.setLearningRatio(((AMRulesRegressor)this.amRules).learningRatioOption.getValue());
        }
        if (((RuleActiveRegressionNode)oldLearningNode).targetMean != null) {
            this.targetMean = new TargetMean(((RuleActiveRegressionNode)oldLearningNode).targetMean);
            this.targetMean.resetError();
        }
        this.nodeStatistics.setValue(0, 0.0);
        this.nodeStatistics.setValue(1, 0.0);
        this.nodeStatistics.setValue(2, 0.0);
    }

    @Override
    public double[] getSimplePrediction() {
        if (this.targetMean != null) {
            return this.targetMean.getVotesForInstance(null);
        }
        return new double[]{0.0};
    }

    @Override
    public boolean tryToExpand(double splitConfidence, double tieThreshold) {
        SDRSplitCriterionAMRules splitCriterion = new SDRSplitCriterionAMRules();
        Object[] bestSplitSuggestions = this.getBestSplitSuggestions(splitCriterion);
        Arrays.sort(bestSplitSuggestions);
        boolean shouldSplit = false;
        if (bestSplitSuggestions.length < 2) {
            shouldSplit = bestSplitSuggestions.length > 0 && ((AttributeSplitSuggestion)bestSplitSuggestions[0]).merit > 0.0;
            this.bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
        } else {
            double hoeffdingBound = RuleActiveRegressionNode.computeHoeffdingBound(1.0, splitConfidence, this.getWeightSeen());
            this.debug("Hoeffding bound " + hoeffdingBound, 4);
            this.bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            this.debug("Merits: " + ((AttributeSplitSuggestion)secondBestSuggestion).merit + " " + this.bestSuggestion.merit, 4);
            if (this.bestSuggestion.merit > 0.0 && (((AttributeSplitSuggestion)secondBestSuggestion).merit / this.bestSuggestion.merit + hoeffdingBound < 1.0 || hoeffdingBound < tieThreshold)) {
                this.debug("Expanded ", 5);
                shouldSplit = true;
            }
        }
        if (shouldSplit) {
            Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            double minValue = Double.MAX_VALUE;
            double[] branchMerits = SDRSplitCriterionAMRules.computeBranchSplitMerits(this.bestSuggestion.resultingClassDistributions);
            for (int i = 0; i < this.bestSuggestion.numSplits(); ++i) {
                double value = branchMerits[i];
                if (!(value < minValue)) continue;
                minValue = value;
                this.splitIndex = i;
                this.statisticsNewRuleActiveLearningNode = this.bestSuggestion.resultingClassDistributionFromSplit(i);
            }
            this.statisticsBranchSplit = ((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(this.splitIndex);
            this.statisticsOtherBranchSplit = this.bestSuggestion.resultingClassDistributionFromSplit(this.splitIndex == 0 ? 1 : 0);
        }
        return shouldSplit;
    }

    @Override
    public void learnFromInstance(Instance inst) {
        this.nodeStatistics.addToValue(0, 1.0);
        this.nodeStatistics.addToValue(1, inst.classValue());
        this.nodeStatistics.addToValue(2, inst.classValue() * inst.classValue());
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            int instAttIndex = AbstractAMRules.modelAttIndexToInstanceAttIndex(i, inst);
            AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
            if (obs == null && inst.attribute(instAttIndex).isNumeric()) {
                obs = this.newNumericClassObserver();
                this.attributeObservers.set(i, obs);
            }
            if (obs == null) continue;
            ((FIMTDDNumericAttributeClassObserver)obs).observeAttributeClass(inst.value(instAttIndex), inst.classValue(), inst.weight());
        }
    }

    public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion) {
        LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
        double[] nodeSplitDist = this.nodeStatistics.getArrayCopy();
        for (int i = 0; i < this.attributeObservers.size(); ++i) {
            AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
            if (obs == null) continue;
            AttributeSplitSuggestion bestSuggestion = null;
            if (obs instanceof FIMTDDNumericAttributeClassObserver) {
                bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, nodeSplitDist, i, true);
            }
            if (bestSuggestion == null) continue;
            bestSuggestions.add(bestSuggestion);
        }
        return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
    }

    @Override
    public double getWeightSeen() {
        if (this.nodeStatistics != null) {
            return this.nodeStatistics.getValue(0);
        }
        return 0.0;
    }

    @Override
    public double getCurrentError() {
        double errorTM;
        double errorP;
        double error = this.perceptron != null ? (this.targetMean == null ? this.perceptron.getCurrentError() : ((errorP = this.perceptron.getCurrentError()) < (errorTM = this.targetMean.getCurrentError()) ? errorP : errorTM)) : Double.MAX_VALUE;
        return error;
    }
}

