/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.streamkm;

import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.streamkm.BucketManager;
import moa.clusterers.streamkm.MTRandom;
import moa.clusterers.streamkm.Point;
import moa.core.Measurement;
import moa.options.IntOption;
import weka.core.Instance;

public class StreamKM
extends AbstractClusterer {
    public IntOption sizeCoresetOption = new IntOption("sizeCoreset", 's', "Size of the coreset.", 10000);
    public IntOption numClustersOption = new IntOption("numClusters", 'k', "Number of clusters to compute.", 5);
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window for training learner.", 100000, 0, Integer.MAX_VALUE);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random behaviour of the classifier.", 1);
    protected MTRandom clustererRandom;
    protected Point[] centresStreamingCoreset;
    protected int numberInstances;
    protected int dimension;
    protected int length;
    protected int numberOfCentres;
    protected int coresetsize;
    protected BucketManager manager;
    protected boolean initialized = false;
    private static final double THRESHOLD = 1.0;

    @Override
    public void resetLearningImpl() {
        this.initialized = false;
        this.coresetsize = this.sizeCoresetOption.getValue();
        this.numberOfCentres = this.numClustersOption.getValue();
        this.length = this.widthOption.getValue();
        this.centresStreamingCoreset = new Point[this.numberOfCentres];
        this.clustererRandom = new MTRandom(this.randomSeedOption.getValue());
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (!this.initialized) {
            this.dimension = inst.numAttributes();
            this.manager = new BucketManager(this.length, this.dimension, this.coresetsize, this.clustererRandom);
            this.initialized = true;
        }
        this.manager.insertPoint(new Point(inst, this.numberInstances));
        ++this.numberInstances;
        if (this.numberInstances % this.widthOption.getValue() == 0) {
            Point[] streamingCoreset = this.manager.getCoresetFromManager(this.dimension);
            double minCost = 0.0;
            double curCost = 0.0;
            curCost = minCost = this.lloydPlusPlus(this.numberOfCentres, this.coresetsize, this.dimension, streamingCoreset, this.centresStreamingCoreset);
            for (int i = 1; i < 5; ++i) {
                Point[] tmpCentresStreamingCoreset = new Point[0];
                curCost = this.lloydPlusPlus(this.numberOfCentres, this.coresetsize, this.dimension, streamingCoreset, tmpCentresStreamingCoreset);
                if (!(curCost < minCost)) continue;
                minCost = curCost;
                this.centresStreamingCoreset = tmpCentresStreamingCoreset;
            }
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Clustering getClusteringResult() {
        if (!this.initialized) {
            return new Clustering();
        }
        Clustering clustering = new Clustering();
        for (int i = 0; i < this.centresStreamingCoreset.length; ++i) {
            if (this.centresStreamingCoreset[i] == null) continue;
            clustering.add(this.centresStreamingCoreset[i].toCluster());
        }
        return clustering;
    }

    public double lloydPlusPlus(int k, int n, int d, Point[] points, Point[] centres) {
        double cost;
        centres = this.chooseRandomCentres(k, n, d, points);
        double newCost = cost = this.targetFunctionValue(k, n, centres, points);
        Point[] massCentres = new Point[k];
        double[] numberOfPoints = new double[k];
        do {
            cost = newCost;
            int i = 0;
            for (i = 0; i < k; ++i) {
                massCentres[i] = new Point(d);
                numberOfPoints[i] = 0.0;
            }
            for (i = 0; i < n; ++i) {
                int centre = points[i].determineClusterCentreKMeans(k, centres);
                for (int l = 0; l < massCentres[centre].dimension; ++l) {
                    if (points[i].weight == 0.0) continue;
                    int n2 = l;
                    massCentres[centre].coordinates[n2] = massCentres[centre].coordinates[n2] + points[i].coordinates[l];
                }
                int n3 = centre;
                numberOfPoints[n3] = numberOfPoints[n3] + points[i].weight;
            }
            for (i = 0; i < k; ++i) {
                for (int l = 0; l < centres[i].dimension; ++l) {
                    centres[i].coordinates[l] = massCentres[i].coordinates[l];
                    centres[i].weight = numberOfPoints[i];
                }
            }
        } while ((newCost = this.targetFunctionValue(k, n, centres, points)) < 1.0 * cost);
        return newCost;
    }

    private Point[] chooseRandomCentres(int k, int n, int d, Point[] points) {
        Point[] centres = new Point[k];
        int i = 0;
        int next = 0;
        int j = 0;
        do {
            next = this.clustererRandom.nextInt(n - 1);
        } while (points[next].weight < 1.0);
        j = next;
        centres[i] = points[j].clone();
        for (i = 0; i < n; ++i) {
            points[i].centreIndex = 0;
            points[i].curCost = points[i].costOfPointToCenter(centres[0]);
        }
        for (i = 1; i < k; ++i) {
            double cost = 0.0;
            for (j = 0; j < n; ++j) {
                cost += points[j].curCost;
            }
            double random = 0.0;
            double sum = 0.0;
            int pos = -1;
            block4: do {
                random = this.clustererRandom.nextDouble();
                sum = 0.0;
                pos = -1;
                for (j = 0; j < n; ++j) {
                    if (!(random <= (sum += points[j].curCost) / cost)) continue;
                    pos = j;
                    continue block4;
                }
            } while (points[pos].weight < 1.0);
            centres[i] = points[pos].clone();
            for (j = 0; j < n; ++j) {
                double newCost = points[j].costOfPointToCenter(centres[i]);
                if (!(points[j].curCost > newCost)) continue;
                points[j].curCost = newCost;
                points[j].centreIndex = i;
            }
        }
        return centres;
    }

    public double targetFunctionValue(int k, int n, Point[] centres, Point[] points) {
        int i = 0;
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            double nearestCost = -1.0;
            int j = 0;
            for (j = 0; j < k; ++j) {
                double distance = 0.0;
                int l = 0;
                for (l = 0; l < points[i].dimension; ++l) {
                    double centroidCoordinatePoint = points[i].weight != 0.0 ? points[i].coordinates[l] / points[i].weight : points[i].coordinates[l];
                    double centroidCoordinateCentre = centres[j].weight != 0.0 ? centres[j].coordinates[l] / centres[j].weight : centres[j].coordinates[l];
                    distance += (centroidCoordinatePoint - centroidCoordinateCentre) * (centroidCoordinatePoint - centroidCoordinateCentre);
                }
                if (!(nearestCost < 0.0) && !(distance < nearestCost)) continue;
                nearestCost = distance;
            }
            sum += nearestCost * points[i].weight;
        }
        return sum;
    }
}

