/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.LearningPerformanceEvaluator;
import weka.core.Utils;

public class BasicClusteringPerformanceEvaluator
extends AbstractMOAObject
implements LearningPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double weightCorrect;

    @Override
    public void reset() {
        this.weightObserved = 0.0;
        this.weightCorrect = 0.0;
    }

    @Override
    public void addLearningAttempt(int trueClass, double[] classVotes, double weight) {
        if (weight > 0.0) {
            this.weightObserved += weight;
            if (Utils.maxIndex((double[])classVotes) == trueClass) {
                this.weightCorrect += weight;
            }
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("instances", this.getTotalWeightObserved())};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved;
    }

    public double getFractionCorrectlyClassified() {
        return this.weightObserved > 0.0 ? this.weightCorrect / this.weightObserved : 0.0;
    }

    public double getFractionIncorrectlyClassified() {
        return 1.0 - this.getFractionCorrectlyClassified();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }
}

