/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;
import weka.core.Instance;

public class BasicConceptDriftPerformanceEvaluator
extends AbstractMOAObject
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double numberDetections;
    protected double numberDetectionsOccurred;
    protected double numberChanges;
    protected double numberWarnings;
    protected double delay;
    protected double errorPrediction;
    protected double totalDelay;
    protected boolean isWarningZone;
    protected double inputValues;
    private boolean hasChangeOccurred = false;

    @Override
    public void reset() {
        this.weightObserved = 0.0;
        this.numberDetections = 0.0;
        this.numberDetectionsOccurred = 0.0;
        this.errorPrediction = 0.0;
        this.numberChanges = 0.0;
        this.numberWarnings = 0.0;
        this.delay = 0.0;
        this.totalDelay = 0.0;
        this.isWarningZone = false;
        this.inputValues = 0.0;
        this.hasChangeOccurred = false;
    }

    @Override
    public void addResult(Instance inst, double[] classVotes) {
        this.inputValues = inst.value(2);
        if (inst.weight() > 0.0 && classVotes.length == 4) {
            if (inst.numAttributes() > 1) {
                this.delay += 1.0;
            }
            this.weightObserved += inst.weight();
            if (classVotes[0] == 1.0) {
                this.numberDetections += inst.weight();
                if (this.hasChangeOccurred) {
                    this.totalDelay += this.delay - classVotes[2];
                    this.numberDetectionsOccurred += inst.weight();
                    this.hasChangeOccurred = false;
                }
            }
            if (this.hasChangeOccurred && classVotes[1] == 1.0) {
                if (!this.isWarningZone) {
                    this.numberWarnings += inst.weight();
                    this.isWarningZone = true;
                }
            } else {
                this.isWarningZone = false;
            }
            if (inst.numAttributes() > 1 && inst.value(inst.numAttributes() - 2) == 1.0) {
                this.numberChanges += inst.weight();
                this.delay = 0.0;
                this.hasChangeOccurred = true;
            }
            if (classVotes.length > 1) {
                this.errorPrediction += Math.abs(classVotes[3] - inst.value(0));
            }
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        Measurement[] measurement = new Measurement[]{new Measurement("learned instances", this.getTotalWeightObserved()), new Measurement("detected changes", this.getNumberDetections()), new Measurement("detected warnings", this.getNumberWarnings()), new Measurement("prediction error (average)", this.getPredictionError() / this.getTotalWeightObserved()), new Measurement("true changes", this.getNumberChanges()), new Measurement("delay detection (average)", this.getTotalDelay() / this.getNumberChanges()), new Measurement("true changes detected", this.getNumberChangesOccurred()), new Measurement("input values", this.getInputValues())};
        return measurement;
    }

    public double getTotalWeightObserved() {
        return this.weightObserved > 0.0 ? this.weightObserved : 1.0;
    }

    public double getNumberDetections() {
        return this.numberDetections;
    }

    public double getInputValues() {
        return this.inputValues;
    }

    public double getPredictionError() {
        return this.errorPrediction;
    }

    public double getNumberChanges() {
        return this.numberChanges;
    }

    public double getNumberChangesOccurred() {
        return this.numberDetectionsOccurred;
    }

    public double getNumberWarnings() {
        return this.numberWarnings;
    }

    public double getTotalDelay() {
        return this.totalDelay;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }
}

