/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators.cd;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.streams.clustering.ClusterEvent;
import moa.streams.generators.cd.ConceptDriftGenerator;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractConceptDriftGenerator
extends AbstractOptionHandler
implements ConceptDriftGenerator {
    protected ArrayList<ClusterEvent> clusterEvents;
    private static final long serialVersionUID = 1L;
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public FlagOption notBinaryStreamOption = new FlagOption("notBinaryStream", 'b', "Don't convert to a binary stream of 0 and 1.");
    public IntOption numInstancesConceptOption = new IntOption("numInstancesConcept", 'p', "The number of instances for each concept.", 500, 0, Integer.MAX_VALUE);
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected int period;
    protected int numInstances;
    protected boolean change;

    @Override
    public String getPurposeString() {
        return "Generates a stream problem of predicting concept drift.";
    }

    @Override
    public ArrayList<ClusterEvent> getEventsList() {
        return this.clusterEvents;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.restart();
        this.numInstances = 0;
        this.period = this.numInstancesConceptOption.getValue();
        FastVector attributes = new FastVector();
        FastVector binaryLabels = new FastVector();
        binaryLabels.addElement((Object)"0");
        binaryLabels.addElement((Object)"1");
        if (!this.notBinaryStreamOption.isSet()) {
            attributes.addElement((Object)new Attribute("input", (List)binaryLabels));
        } else {
            attributes.addElement((Object)new Attribute("input"));
        }
        attributes.addElement((Object)new Attribute("change", (List)binaryLabels));
        attributes.addElement((Object)new Attribute("ground truth input"));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), (ArrayList)attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.clusterEvents = new ArrayList();
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    protected abstract double nextValue();

    private int nextbinaryValue(double num) {
        int res = 0;
        if (this.instanceRandom.nextDouble() <= num) {
            res = 1;
        }
        return res;
    }

    public boolean getChange() {
        return this.change;
    }

    @Override
    public Instance nextInstance() {
        ++this.numInstances;
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance(header.numAttributes());
        inst.setDataset((Instances)header);
        double nextValue = this.nextValue();
        if (this.notBinaryStreamOption.isSet()) {
            inst.setValue(0, nextValue);
        } else {
            inst.setValue(0, (double)this.nextbinaryValue(nextValue));
        }
        inst.setValue(1, this.getChange() ? 1.0 : 0.0);
        if (this.getChange()) {
            // empty if block
        }
        inst.setValue(2, nextValue);
        return inst;
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

