/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import moa.classifiers.trees.DecisionStump;
import moa.options.ClassOption;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MOAUtils;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class MOA
extends AbstractClassifier
implements UpdateableClassifier {
    private static final long serialVersionUID = 2605797948130310166L;
    protected moa.classifiers.Classifier m_ActualClassifier = new DecisionStump();
    protected ClassOption m_Classifier = new ClassOption("classifier", 'B', "The MOA classifier to use from within WEKA.", moa.classifiers.Classifier.class, this.m_ActualClassifier.getClass().getName().replace("moa.classifiers.", ""), this.m_ActualClassifier.getClass().getName());

    public String globalInfo() {
        return "Wrapper for MOA classifiers.\n\nSince MOA doesn't offer a mechanism to query a classifier for the types of attributes and classes it can handle, the capabilities of this wrapper are hard-coded: nominal and numeric attributes and only nominal class attributes are allowed.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe MOA classifier to use.\n\t(default: " + MOAUtils.toCommandLine(new DecisionStump()) + ")", "B", 1, "-B <classname + options>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'B', (String[])options);
        ClassOption option = (ClassOption)this.m_Classifier.copy();
        if (tmpStr.length() == 0) {
            option.setCurrentObject(new DecisionStump());
        } else {
            option.setCurrentObject(MOAUtils.fromCommandLine(this.m_Classifier, tmpStr));
        }
        this.setClassifier(option);
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-B");
        result.add(MOAUtils.toCommandLine(this.m_ActualClassifier));
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setClassifier(ClassOption value) {
        this.m_Classifier = value;
        this.m_ActualClassifier = (moa.classifiers.Classifier)MOAUtils.fromOption(this.m_Classifier);
    }

    public ClassOption getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The MOA classifier to use.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_ActualClassifier.resetLearning();
        for (int i = 0; i < data.numInstances(); ++i) {
            this.updateClassifier(data.instance(i));
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        this.m_ActualClassifier.trainOnInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = this.m_ActualClassifier.getVotesForInstance(instance);
        if (result.length < instance.numClasses()) {
            double[] newResult = new double[instance.numClasses()];
            System.arraycopy(result, 0, newResult, 0, result.length);
            result = newResult;
        }
        try {
            Utils.normalize((double[])result);
        }
        catch (Exception e) {
            result = new double[instance.numClasses()];
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.m_ActualClassifier.getDescription(result, 0);
        return result.toString();
    }

    public static void main(String[] args) {
        MOA.runClassifier((Classifier)new MOA(), (String[])args);
    }
}

