/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Range;
import adams.data.io.input.ExcelSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.previewbrowser.AbstractSpreadSheetHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSpreadSheetHandler
extends AbstractSpreadSheetHandler {
    private static final long serialVersionUID = -3962259305718630395L;

    public String[] getExtensions() {
        return new String[]{"xls", "xlsx"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSheetCount(File file) {
        int result;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            Workbook workbook = WorkbookFactory.create((InputStream)input);
            result = workbook.getNumberOfSheets();
        }
        catch (Exception e) {
            result = 0;
            this.getLogger().log(Level.SEVERE, "Failed to determine sheet count for '" + file + "':", e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    protected SpreadSheet[] readAll(File file) {
        List result = new ArrayList();
        ExcelSpreadSheetReader reader = new ExcelSpreadSheetReader();
        reader.setSheetRange(new Range("first-last"));
        result = reader.readRange(file);
        return result.toArray(new SpreadSheet[result.size()]);
    }
}

