/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.data.mapobject.MetaDataSupporter;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SparseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.sink.openstreetmapviewer.AbstractMapObjectHitListenerWithDialog;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import java.awt.Container;
import java.awt.Dialog;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public class TableMapObjectHitListener
extends AbstractMapObjectHitListenerWithDialog<SpreadSheetDialog> {
    private static final long serialVersionUID = -613241778857988225L;

    public String globalInfo() {
        return "Displays all the hits in a table format.";
    }

    @Override
    protected SpreadSheetDialog doProcessHits(JMapViewer viewer, List<MapObject> hits) {
        SpreadSheet sheet = new SpreadSheet();
        sheet.setDataRowClass(SparseDataRow.class);
        HeaderRow row = sheet.getHeaderRow();
        row.addCell("name").setContent("Name");
        row.addCell("layer").setContent("Layer");
        List<String> keys = this.getMetaDataKeys(hits);
        for (String key : keys) {
            row.addCell("meta-" + key).setContentAsString(key);
        }
        for (MapObject hit : hits) {
            row = sheet.addRow();
            row.addCell("name").setContentAsString(hit.getName());
            row.addCell("layer").setContentAsString(hit.getLayer().getName());
            if (!(hit instanceof MetaDataSupporter)) continue;
            MetaDataSupporter meta = (MetaDataSupporter)hit;
            for (String key : keys) {
                if (meta.getMetaData(key) == null) continue;
                row.addCell("meta-" + key).setContent(meta.getMetaData(key).toString());
            }
        }
        SpreadSheetDialog result = GUIHelper.getParentDialog((Container)viewer) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)viewer), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)viewer), false);
        result.setTitle(this.getTitle());
        result.setShowSearch(true);
        result.setSpreadSheet(sheet);
        return result;
    }
}

