/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class ImplAverageDownSampleN {
    public static void down(ImageUInt8 input, int sampleWidth, ImageInt8 output) {
        int indexOut;
        int endBoxY;
        int indexOut2;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        int y = 0;
        int outY = 0;
        while (y < maxY) {
            indexOut2 = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut2++] = (byte)((total + N_half) / N);
            }
            y += sampleWidth;
            ++outY;
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            y = 0;
            outY = 0;
            while (y < maxY) {
                indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut2] = (byte)((total + N_half) / N);
                y += sampleWidth;
                ++outY;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut++] = (byte)((total + N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++] & 0xFF;
                }
            }
            output.data[indexOut] = (byte)((total + N_half) / N);
        }
    }

    public static void down(ImageSInt8 input, int sampleWidth, ImageInt8 output) {
        int indexOut;
        int endBoxY;
        int indexOut2;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        int y = 0;
        int outY = 0;
        while (y < maxY) {
            indexOut2 = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2++] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
            }
            y += sampleWidth;
            ++outY;
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            y = 0;
            outY = 0;
            while (y < maxY) {
                indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
                y += sampleWidth;
                ++outY;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
        }
    }

    public static void down(ImageUInt16 input, int sampleWidth, ImageInt16 output) {
        int indexOut;
        int endBoxY;
        int indexOut2;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        int y = 0;
        int outY = 0;
        while (y < maxY) {
            indexOut2 = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut2++] = (short)((total + N_half) / N);
            }
            y += sampleWidth;
            ++outY;
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            y = 0;
            outY = 0;
            while (y < maxY) {
                indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut2] = (short)((total + N_half) / N);
                y += sampleWidth;
                ++outY;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut++] = (short)((total + N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++] & 0xFFFF;
                }
            }
            output.data[indexOut] = (short)((total + N_half) / N);
        }
    }

    public static void down(ImageSInt16 input, int sampleWidth, ImageInt16 output) {
        int indexOut;
        int endBoxY;
        int indexOut2;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        int y = 0;
        int outY = 0;
        while (y < maxY) {
            indexOut2 = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2++] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
            }
            y += sampleWidth;
            ++outY;
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            y = 0;
            outY = 0;
            while (y < maxY) {
                indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
                y += sampleWidth;
                ++outY;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
        }
    }

    public static void down(ImageSInt32 input, int sampleWidth, ImageSInt32 output) {
        int indexOut;
        int endBoxY;
        int indexOut2;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        int y = 0;
        int outY = 0;
        while (y < maxY) {
            indexOut2 = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2++] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
            }
            y += sampleWidth;
            ++outY;
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            y = 0;
            outY = 0;
            while (y < maxY) {
                indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                int total = 0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
                y += sampleWidth;
                ++outY;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total = 0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total = 0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
        }
    }

    public static void down(ImageFloat32 input, int sampleWidth, ImageFloat32 output) {
        int indexOut;
        int endBoxY;
        int indexOut2;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        float N = sampleWidth * sampleWidth;
        int y = 0;
        int outY = 0;
        while (y < maxY) {
            indexOut2 = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                float total = 0.0f;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2++] = total / N;
            }
            y += sampleWidth;
            ++outY;
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            y = 0;
            outY = 0;
            while (y < maxY) {
                indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                float total = 0.0f;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2] = total / N;
                y += sampleWidth;
                ++outY;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                float total = 0.0f;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total / N;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            float total = 0.0f;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total / N;
        }
    }

    public static void down(ImageFloat64 input, int sampleWidth, ImageFloat64 output) {
        int indexOut;
        int endBoxY;
        int indexOut2;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        double N = sampleWidth * sampleWidth;
        int y = 0;
        int outY = 0;
        while (y < maxY) {
            indexOut2 = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                double total = 0.0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2++] = total / N;
            }
            y += sampleWidth;
            ++outY;
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            y = 0;
            outY = 0;
            while (y < maxY) {
                indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                double total = 0.0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2] = total / N;
                y += sampleWidth;
                ++outY;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            indexOut = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                double total = 0.0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total / N;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            indexOut = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            double total = 0.0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut] = total / N;
        }
    }
}

