/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.ellipse;

import georegression.struct.point.Vector2D_F64;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;

public class CovarianceToEllipse_F64 {
    EigenDecomposition<DenseMatrix64F> eigen = DecompositionFactory.eig((int)2, (boolean)true);
    DenseMatrix64F Q = new DenseMatrix64F(2, 2);
    Vector2D_F64 x = new Vector2D_F64();
    Vector2D_F64 y = new Vector2D_F64();
    double lengthX;
    double lengthY;
    double numStdev = 1.0;

    public void setNumStdev(double numStdev) {
        this.numStdev = numStdev;
    }

    public boolean setCovariance(double a11, double a12, double a22) {
        DenseMatrix64F a1;
        DenseMatrix64F a0;
        this.Q.data[0] = a11;
        this.Q.data[1] = a12;
        this.Q.data[2] = a12;
        this.Q.data[3] = a22;
        if (!this.eigen.decompose((Matrix64F)this.Q)) {
            System.err.println("Eigenvalue decomposition failed!");
            return false;
        }
        Complex64F v0 = this.eigen.getEigenvalue(0);
        Complex64F v1 = this.eigen.getEigenvalue(1);
        if (v0.getMagnitude2() > v1.getMagnitude2()) {
            a0 = (DenseMatrix64F)this.eigen.getEigenVector(0);
            a1 = (DenseMatrix64F)this.eigen.getEigenVector(1);
            this.lengthX = v0.getMagnitude();
            this.lengthY = v1.getMagnitude();
        } else {
            a0 = (DenseMatrix64F)this.eigen.getEigenVector(1);
            a1 = (DenseMatrix64F)this.eigen.getEigenVector(0);
            this.lengthX = v1.getMagnitude();
            this.lengthY = v0.getMagnitude();
        }
        if (a0 == null || a1 == null) {
            System.err.println("Complex eigenvalues: " + v0 + "  " + v1);
            return false;
        }
        this.lengthX = Math.sqrt(this.lengthX);
        this.lengthY = Math.sqrt(this.lengthY);
        this.x.set(a0.get(0), a0.get(1));
        this.y.set(a1.get(0), a1.get(1));
        return true;
    }

    public Vector2D_F64 getMajorVector() {
        return this.x;
    }

    public Vector2D_F64 getMinorVector() {
        return this.y;
    }

    public double getAngle() {
        return Math.atan2(this.x.y, this.x.x);
    }

    public double getMajorAxis() {
        return this.numStdev * this.lengthX;
    }

    public double getMinorAxis() {
        return this.numStdev * this.lengthY;
    }
}

