/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipUtils {
    public static String compress(File output, File[] files) {
        return ZipUtils.compress(output, files, 1024);
    }

    public static String compress(File output, File[] files, int bufferSize) {
        return ZipUtils.compress(output, files, "", bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Apache compress commons", license=License.APACHE2, url="http://commons.apache.org/compress/examples.html")
    public static String compress(File output, File[] files, String stripRegExp, int bufferSize) {
        BufferedInputStream in = null;
        FileInputStream fis = null;
        ZipArchiveOutputStream out = null;
        FileOutputStream fos = null;
        String result = null;
        try {
            if (output.exists()) {
                System.err.println("WARNING: overwriting '" + output + "'!");
            }
            byte[] buf = new byte[bufferSize];
            fos = new FileOutputStream(output.getAbsolutePath());
            out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(fos));
            for (int i = 0; i < files.length; ++i) {
                int len;
                fis = new FileInputStream(files[i].getAbsolutePath());
                in = new BufferedInputStream(fis);
                String filename = files[i].getParentFile().getAbsolutePath();
                if (stripRegExp.length() > 0) {
                    filename = filename.replaceFirst(stripRegExp, "");
                }
                if (filename.length() > 0) {
                    filename = filename + File.separator;
                }
                filename = filename + files[i].getName();
                ZipArchiveEntry entry = new ZipArchiveEntry(filename);
                entry.setSize(files[i].length());
                out.putArchiveEntry((ArchiveEntry)entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeArchiveEntry();
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((InputStream)fis);
                in = null;
                fis = null;
            }
            FileUtils.closeQuietly((OutputStream)out);
            FileUtils.closeQuietly((OutputStream)fos);
            out = null;
            fos = null;
        }
        catch (Exception e) {
            try {
                String msg = "Failed to generate archive '" + output + "': ";
                System.err.println(msg);
                e.printStackTrace();
                result = msg + e;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(in);
                FileUtils.closeQuietly(fis);
                FileUtils.closeQuietly(out);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly(in);
            FileUtils.closeQuietly(fis);
            FileUtils.closeQuietly((OutputStream)out);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly(in);
        FileUtils.closeQuietly((InputStream)fis);
        FileUtils.closeQuietly((OutputStream)out);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    public static List<File> decompress(File input, File outputDir) {
        return ZipUtils.decompress(input, outputDir, false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs) {
        return ZipUtils.decompress(input, outputDir, createDirs, new BaseRegExp(""), false);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch) {
        return ZipUtils.decompress(input, outputDir, createDirs, match, invertMatch, 1024);
    }

    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize) {
        return ZipUtils.decompress(input, outputDir, createDirs, match, invertMatch, bufferSize, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MixedCopyright(copyright="Apache compress commons", license=License.APACHE2, url="http://commons.apache.org/compress/examples.html")
    public static List<File> decompress(File input, File outputDir, boolean createDirs, BaseRegExp match, boolean invertMatch, int bufferSize, StringBuilder errors) {
        ArrayList<File> result = new ArrayList<File>();
        ZipFile archive = null;
        try {
            byte[] buffer = new byte[bufferSize];
            archive = new ZipFile(input.getAbsoluteFile());
            Enumeration enm = archive.getEntries();
            while (enm.hasMoreElements()) {
                FileOutputStream fos;
                BufferedOutputStream out;
                BufferedInputStream in;
                block23: {
                    block22: {
                        String error;
                        File outFile;
                        ZipArchiveEntry entry = (ZipArchiveEntry)enm.nextElement();
                        if (entry.isDirectory() && !createDirs || !match.isMatchAll() && !match.isEmpty() && (invertMatch && match.isMatch(entry.getName()) || !invertMatch && !match.isMatch(entry.getName()))) continue;
                        if (entry.isDirectory() && createDirs) {
                            outFile = new File(outputDir.getAbsolutePath() + File.separator + entry.getName());
                            if (outFile.mkdirs()) continue;
                            error = "Failed to create directory '" + outFile.getAbsolutePath() + "'!";
                            System.err.println(error);
                            errors.append(error + "\n");
                            continue;
                        }
                        in = null;
                        out = null;
                        fos = null;
                        String outName = null;
                        try {
                            int len;
                            outName = outputDir.getAbsolutePath() + File.separator;
                            outName = createDirs ? outName + entry.getName() : outName + new File(entry.getName()).getName();
                            outFile = new File(outName).getParentFile();
                            if (!outFile.exists() && !outFile.mkdirs()) {
                                error = "Failed to create directory '" + outFile.getAbsolutePath() + "', " + "skipping extraction of '" + outName + "'!";
                                System.err.println(error);
                                errors.append(error + "\n");
                                FileUtils.closeQuietly((InputStream)in);
                                break block22;
                            }
                            in = new BufferedInputStream(archive.getInputStream(entry));
                            fos = new FileOutputStream(outName);
                            out = new BufferedOutputStream(fos, bufferSize);
                            for (long read = 0L; read < entry.getSize(); read += (long)len) {
                                len = in.read(buffer);
                                out.write(buffer, 0, len);
                            }
                            result.add(new File(outName));
                            FileUtils.closeQuietly((InputStream)in);
                            break block23;
                        }
                        catch (Exception e) {
                            error = "Error extracting '" + entry.getName() + "' to '" + outName + "': " + e;
                            System.err.println(error);
                            errors.append(error + "\n");
                            continue;
                        }
                    }
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                continue;
                finally {
                    FileUtils.closeQuietly(in);
                    FileUtils.closeQuietly(out);
                    FileUtils.closeQuietly(fos);
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
            return result;
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean decompress(File input, String archiveFile, File output) {
        return ZipUtils.decompress(input, archiveFile, output, false);
    }

    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs) {
        return ZipUtils.decompress(input, archiveFile, output, createDirs, 1024, new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean decompress(File input, String archiveFile, File output, boolean createDirs, int bufferSize, StringBuilder errors) {
        boolean result = false;
        ZipFile zipfile = null;
        try {
            byte[] buffer = new byte[bufferSize];
            zipfile = new ZipFile(input.getAbsoluteFile());
            Enumeration enm = zipfile.getEntries();
            while (enm.hasMoreElements()) {
                String error;
                String outName;
                FileOutputStream fos;
                BufferedOutputStream out;
                BufferedInputStream in;
                ZipArchiveEntry entry;
                block20: {
                    File outFile;
                    block21: {
                        entry = (ZipArchiveEntry)enm.nextElement();
                        if (entry.isDirectory() || !entry.getName().equals(archiveFile)) continue;
                        in = null;
                        out = null;
                        fos = null;
                        outName = null;
                        outName = output.getAbsolutePath();
                        outFile = new File(outName).getParentFile();
                        if (outFile.exists()) break block20;
                        if (createDirs) break block21;
                        error = "Output directory '" + outFile.getAbsolutePath() + " does not exist', " + "skipping extraction of '" + outName + "'!";
                        System.err.println(error);
                        errors.append(error + "\n");
                        FileUtils.closeQuietly((InputStream)in);
                        FileUtils.closeQuietly((OutputStream)out);
                        FileUtils.closeQuietly((OutputStream)fos);
                        return result;
                    }
                    if (outFile.mkdirs()) break block20;
                    error = "Failed to create directory '" + outFile.getAbsolutePath() + "', " + "skipping extraction of '" + outName + "'!";
                    System.err.println(error);
                    errors.append(error + "\n");
                    FileUtils.closeQuietly((InputStream)in);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    return result;
                }
                try {
                    int len;
                    in = new BufferedInputStream(zipfile.getInputStream(entry));
                    fos = new FileOutputStream(outName);
                    out = new BufferedOutputStream(fos, bufferSize);
                    for (long read = 0L; read < entry.getSize(); read += (long)len) {
                        len = in.read(buffer);
                        out.write(buffer, 0, len);
                    }
                    result = true;
                }
                catch (Exception e) {
                    try {
                        result = false;
                        error = "Error extracting '" + entry.getName() + "' to '" + outName + "': " + e;
                        System.err.println(error);
                        errors.append(error + "\n");
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(in);
                        FileUtils.closeQuietly(out);
                        FileUtils.closeQuietly(fos);
                        throw throwable;
                        return result;
                    }
                    FileUtils.closeQuietly((InputStream)in);
                    FileUtils.closeQuietly((OutputStream)out);
                    FileUtils.closeQuietly((OutputStream)fos);
                    continue;
                }
                FileUtils.closeQuietly((InputStream)in);
                FileUtils.closeQuietly((OutputStream)out);
                FileUtils.closeQuietly((OutputStream)fos);
                return result;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            errors.append("Error occurred: " + e + "\n");
            return result;
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static List<File> listFiles(File input) {
        return ZipUtils.listFiles(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> listFiles(File input, boolean listDirs) {
        ArrayList<File> result = new ArrayList<File>();
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(input.getAbsoluteFile());
            Enumeration enm = zipfile.getEntries();
            while (enm.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)enm.nextElement();
                if (entry.isDirectory() && listDirs) {
                    result.add(new File(entry.getName()));
                    continue;
                }
                result.add(new File(entry.getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }
}

