/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailHelper;
import adams.core.net.JavaMailSendEmail;
import adams.core.option.OptionUtils;
import adams.data.io.input.EmailFileReader;
import adams.data.io.input.MultiEmailReader;
import adams.data.io.input.PropertiesEmailFileReader;
import adams.env.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SimpleMailer {
    protected int m_DebugLevel;
    protected EmailFileReader m_Reader;
    protected PlaceholderDirectory m_WatchDir;
    protected BaseRegExp m_RegExp;
    protected AbstractSendEmail m_SendEmail;
    protected String m_SuccessfulSuffix;
    protected String m_FailedSuffix;

    public void setDebugLevel(int value) {
        this.m_DebugLevel = value;
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    public String debugLevelTipText() {
        return "The greater the number the more additional info the scheme may output to the console (0 = off).";
    }

    protected boolean isDebugOn() {
        return this.m_DebugLevel > 0;
    }

    protected void debug(String msg) {
        this.debug(msg, 1);
    }

    protected void debug(String msg, int level) {
        if (level <= this.m_DebugLevel) {
            System.out.println("[DEBUG] " + msg);
        }
    }

    public void setReader(EmailFileReader value) {
        this.m_Reader = value;
    }

    public EmailFileReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader for reading the email files.";
    }

    public void setWatchDir(PlaceholderDirectory value) {
        this.m_WatchDir = value;
    }

    public PlaceholderDirectory getWatchDir() {
        return this.m_WatchDir;
    }

    public String watchDirTipText() {
        return "The directory to watch.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the files against.";
    }

    public void setSendEmail(AbstractSendEmail value) {
        this.m_SendEmail = value;
    }

    public AbstractSendEmail getSendEmail() {
        return this.m_SendEmail;
    }

    public String sendEmailTipText() {
        return "The send email scheme to use.";
    }

    public void setSuccessfulSuffix(String value) {
        this.m_SuccessfulSuffix = value;
    }

    public String getSuccessfulSuffix() {
        return this.m_SuccessfulSuffix;
    }

    public String successfulSuffixTipText() {
        return "The suffix to use for successfully sent emails.";
    }

    public void setFailedSuffix(String value) {
        this.m_FailedSuffix = value;
    }

    public String getFailedSuffix() {
        return this.m_FailedSuffix;
    }

    public String failedSuffixTipText() {
        return "The suffix to use for emails that couldn't get sent.";
    }

    protected String[] list() {
        DirectoryLister lister = new DirectoryLister();
        lister.setDebug(this.getDebugLevel() > 1);
        lister.setWatchDir(this.m_WatchDir);
        lister.setListFiles(true);
        lister.setRecursive(false);
        lister.setRegExp(this.m_RegExp);
        return lister.list();
    }

    public void execute() {
        String[] files = this.list();
        if (this.isDebugOn()) {
            this.debug("# files found: " + files.length);
        }
        if (files.length == 0) {
            if (this.isDebugOn()) {
                this.debug("Finished!");
            }
            return;
        }
        for (String file : files) {
            if (this.isDebugOn()) {
                this.debug("Processing: " + file);
            }
            boolean failed = false;
            List<Email> emails = null;
            try {
                this.m_Reader.setInput(new PlaceholderFile(file));
                if (this.m_Reader instanceof MultiEmailReader) {
                    emails = ((MultiEmailReader)((Object)this.m_Reader)).readAll();
                    if (emails == null) {
                        System.err.println("Failed to load emails from file: " + file);
                    }
                } else {
                    Email email = this.m_Reader.read();
                    if (email == null) {
                        System.err.println("Failed to load email from file: " + file);
                    } else {
                        emails = new ArrayList<Email>();
                        emails.add(email);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load email file: " + file);
                e.printStackTrace();
                emails = null;
                failed = true;
            }
            if (emails != null) {
                for (Email eml : emails) {
                    if (this.isDebugOn()) {
                        this.debug("--> Sending: " + (Object)((Object)eml));
                    }
                    try {
                        this.m_SendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpUseSSL(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword());
                        if (!this.m_SendEmail.sendMail(eml)) {
                            System.err.println("Failed to send email!");
                            if (!this.isDebugOn()) continue;
                            this.debug("--> Failed!");
                            continue;
                        }
                        if (!this.isDebugOn()) continue;
                        this.debug("--> Success!");
                    }
                    catch (Exception e) {
                        System.err.println("Failed to send email: " + (Object)((Object)eml));
                        e.printStackTrace();
                        failed = true;
                    }
                }
            }
            PlaceholderFile from = new PlaceholderFile(file);
            PlaceholderFile to = failed ? new PlaceholderFile(file + this.m_FailedSuffix) : new PlaceholderFile(file + this.m_SuccessfulSuffix);
            try {
                if (this.isDebugOn()) {
                    this.debug("--> Renaming '" + from + "' to '" + to + "'");
                }
                FileUtils.move((File)from, (File)to);
                if (!this.isDebugOn()) continue;
                this.debug("--> Success!");
            }
            catch (Exception e) {
                System.err.println("Failed to move file from '" + from + "' to '" + to + "'!");
                e.printStackTrace();
                if (!this.isDebugOn()) continue;
                this.debug("--> Failed!");
            }
        }
        if (this.isDebugOn()) {
            this.debug("Finished!");
        }
    }

    public static void runMailer(String[] options) {
        try {
            String env = OptionUtils.getOption((String[])options, (String)"-env");
            if (env == null || env.length() == 0) {
                env = Environment.class.getName();
            }
            Environment.setEnvironmentClass(Class.forName(env));
            if (OptionUtils.helpRequested((String[])options)) {
                System.out.println("Help requested...\n");
                System.out.println("-env <classname>");
                System.out.println("\tThe environment class to use");
                System.out.println("\tdefault: " + Environment.class.getName());
                System.out.println("-D <level>");
                System.out.println("\tThe debug level (0 means off, >0 means on).");
                System.out.println("-reader <classname>");
                System.out.println("\tThe reader for reading the email files.");
                System.out.println("-watch-dir <directory>");
                System.out.println("\tThe directory to watch.");
                System.out.println("-regexp <expression>");
                System.out.println("\tThe regular expression to match the files against.");
                System.out.println("-send-email <classname+options>");
                System.out.println("\tThe send email scheme to use.");
                System.out.println("-successful-suffix");
                System.out.println("\tThe suffix to use for successfully sent emails.");
                System.out.println("-failed-suffix");
                System.out.println("\tThe suffix to use for emails that couldn't get sent.");
                System.out.println();
            } else {
                SimpleMailer simple = new SimpleMailer();
                String opt = OptionUtils.getOption((String[])options, (String)"-D");
                if (opt != null) {
                    simple.setDebugLevel(Integer.parseInt(opt));
                } else {
                    simple.setDebugLevel(0);
                }
                opt = OptionUtils.getOption((String[])options, (String)"-reader");
                if (opt != null) {
                    simple.setReader((EmailFileReader)OptionUtils.forCommandLine(EmailFileReader.class, (String)opt));
                } else {
                    simple.setReader(new PropertiesEmailFileReader());
                }
                opt = OptionUtils.getOption((String[])options, (String)"-watch-dir");
                if (opt != null) {
                    simple.setWatchDir(new PlaceholderDirectory(opt));
                } else {
                    simple.setWatchDir(new PlaceholderDirectory());
                }
                opt = OptionUtils.getOption((String[])options, (String)"-regexp");
                if (opt != null) {
                    simple.setRegExp(new BaseRegExp(opt));
                } else {
                    simple.setRegExp(new BaseRegExp(".*"));
                }
                opt = OptionUtils.getOption((String[])options, (String)"-send-email");
                if (opt != null) {
                    simple.setSendEmail((AbstractSendEmail)OptionUtils.forCommandLine(AbstractSendEmail.class, (String)opt));
                } else {
                    simple.setSendEmail(new JavaMailSendEmail());
                }
                opt = OptionUtils.getOption((String[])options, (String)"-successful-suffix");
                if (opt != null) {
                    simple.setSuccessfulSuffix(opt);
                } else {
                    simple.setSuccessfulSuffix(".sent");
                }
                opt = OptionUtils.getOption((String[])options, (String)"-failed-suffix");
                if (opt != null) {
                    simple.setFailedSuffix(opt);
                } else {
                    simple.setFailedSuffix(".failed");
                }
                simple.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SimpleMailer.runMailer(args);
    }
}

