/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel;

import java.util.HashMap;
import moa.classifiers.AbstractClassifier;
import moa.core.InstancesHeader;
import moa.core.Measurement;
import weka.core.Instance;

public class MajorityLabelset
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    private int m_L = -1;
    private double maxValue = 0.0;
    private double[] prediction = null;
    private HashMap<String, Double> classFreqs = new HashMap();

    private static final String toBitString(Instance ins, int c) {
        StringBuilder sb = new StringBuilder(c);
        for (int i = 0; i < c; ++i) {
            sb.append((int)Math.round(ins.value(i)));
        }
        return sb.toString();
    }

    protected void updateCount(Instance x, int L) {
        String y = MajorityLabelset.toBitString(x, L);
        if (this.classFreqs.containsKey(y)) {
            double freq = this.classFreqs.get(y) + x.weight();
            this.classFreqs.put(y, freq);
            if (freq >= this.maxValue) {
                this.maxValue = freq;
                this.prediction = new double[L];
                for (int j = 0; j < L; ++j) {
                    this.prediction[j] = x.value(j);
                }
            }
        } else {
            this.classFreqs.put(y, x.weight());
        }
    }

    @Override
    public void setModelContext(InstancesHeader raw_header) {
        this.modelContext = raw_header;
        this.m_L = raw_header.classIndex() + 1;
        this.prediction = new double[this.m_L];
    }

    @Override
    public void resetLearningImpl() {
    }

    @Override
    public void trainOnInstanceImpl(Instance x) {
        this.updateCount(x, this.m_L);
    }

    @Override
    public double[] getVotesForInstance(Instance x) {
        int L = x.classIndex() + 1;
        if (this.m_L != L) {
            System.err.println("set L = " + L);
            this.m_L = L;
            this.prediction = new double[this.m_L];
        }
        return this.prediction;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[0];
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }
}

