/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.conditionaltests;

import moa.classifiers.core.conditionaltests.InstanceConditionalBinaryTest;
import moa.classifiers.rules.core.Predicate;
import moa.core.InstancesHeader;
import weka.core.Instance;

public class NumericAttributeBinaryRulePredicate
extends InstanceConditionalBinaryTest
implements Predicate {
    private static final long serialVersionUID = 1L;
    protected int attIndex;
    protected double attValue;
    protected int operator;

    public NumericAttributeBinaryRulePredicate(int attIndex, double attValue, int operator) {
        this.attIndex = attIndex;
        this.attValue = attValue;
        this.operator = operator;
    }

    @Override
    public int branchForInstance(Instance inst) {
        int instAttIndex;
        int n = instAttIndex = this.attIndex < inst.classIndex() ? this.attIndex : this.attIndex + 1;
        if (inst.isMissing(instAttIndex)) {
            return -1;
        }
        double v = inst.value(instAttIndex);
        int ret = 0;
        switch (this.operator) {
            case 0: {
                ret = v == this.attValue ? 0 : 1;
                break;
            }
            case 1: {
                ret = v <= this.attValue ? 0 : 1;
                break;
            }
            case 2: {
                ret = v > this.attValue ? 0 : 1;
            }
        }
        return ret;
    }

    @Override
    public String describeConditionForBranch(int branch, InstancesHeader context) {
        if (branch >= 0 && branch <= 2) {
            String compareChar = branch == 0 ? "=" : (branch == 1 ? "<=" : ">");
            return InstancesHeader.getAttributeNameString(context, this.attIndex) + ' ' + compareChar + InstancesHeader.getNumericValueString(context, this.attIndex, this.attValue);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public int[] getAttsTestDependsOn() {
        return new int[]{this.attIndex};
    }

    public double getSplitValue() {
        return this.attValue;
    }

    @Override
    public boolean evaluate(Instance inst) {
        return this.branchForInstance(inst) == 0;
    }

    @Override
    public String toString() {
        if (this.operator >= 0 && this.operator <= 2) {
            String compareChar = this.operator == 0 ? "=" : (this.operator == 1 ? "<=" : ">");
            return "x" + this.attIndex + ' ' + compareChar + ' ' + this.attValue;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean isEqual(NumericAttributeBinaryRulePredicate predicate) {
        return this.attIndex == predicate.attIndex && this.attValue == predicate.attValue && this.operator == predicate.operator;
    }

    public boolean isUsingSameAttribute(NumericAttributeBinaryRulePredicate predicate) {
        return this.attIndex == predicate.attIndex && this.operator == predicate.operator;
    }

    public boolean isIncludedInRuleNode(NumericAttributeBinaryRulePredicate predicate) {
        boolean ret = this.operator == 1 ? predicate.attValue <= this.attValue : predicate.attValue > this.attValue;
        return ret;
    }

    public void setAttributeValue(NumericAttributeBinaryRulePredicate ruleSplitNodeTest) {
        this.attValue = ruleSplitNodeTest.attValue;
    }
}

