/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import moa.AbstractMOAObject;
import moa.classifiers.Regressor;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.FIMTDDNumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.splitcriteria.SDRSplitCriterion;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.classifiers.trees.HoeffdingTree;
import moa.core.DoubleVector;
import moa.options.ClassOption;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.Instance;

public class FIMTDD
extends HoeffdingTree
implements Regressor {
    private static final long serialVersionUID = 1L;
    protected DoubleVector splitRatioStatistics = new DoubleVector();
    protected ArrayList<FIMTDDSplitNode> nodesToAdapt = new ArrayList();
    protected boolean Adaptable = true;
    protected double initLearnRate = 0.1;
    protected double learnRateDecay = 0.001;
    public FloatOption PageHinckleyAlphaOption = new FloatOption("PageHinckleyAlpha", 'a', "The alpha value to use in the Page Hinckley change detection tests.", 0.005, 0.0, 1.0);
    public IntOption PageHinckleyThresholdOption = new IntOption("PageHinckleyThreshold", 'h', "The threshold value to be used in the Page Hinckley change detection tests.", 50, 0, Integer.MAX_VALUE);
    public FloatOption AlternateTreeFadingFactorOption = new FloatOption("AlternateTreeFadingFactor", 'f', "The fading factor to use when deciding if an alternate tree should replace an original.", 0.995, 0.0, 1.0);
    public IntOption AlternateTreeTMinOption = new IntOption("AlternateTreeTMin", 'y', "The Tmin value to use when deciding if an alternate tree should replace an original.", 150, 0, Integer.MAX_VALUE);
    public IntOption AlternateTreeTimeOption = new IntOption("AlternateTreeTime", 'u', "The 'time' (in terms of number of instances) value to use when deciding if an alternate tree should be discarded.", 1500, 0, Integer.MAX_VALUE);
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'w', "Learning ratio to use for training the Perceptrons in the leaves.", 0.01);
    public FlagOption learningRatio_Decay_or_Const_Option = new FlagOption("learningRatio_Decay_or_Const", 'j', "learning Ratio Decay or const parameter.");

    @Override
    public String getPurposeString() {
        return "Implementation of the FIMT-DD tree as described by Ikonomovska et al.";
    }

    public FIMTDD() {
        this.numericEstimatorOption = new ClassOption("numericEstimator", 'n', "Numeric estimator to use.", FIMTDDNumericAttributeClassObserver.class, "FIMTDDNumericAttributeClassObserver");
        this.splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", SDRSplitCriterion.class, "SDRSplitCriterion");
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLearningNode();
            this.activeLeafNodeCount = 1;
        }
        HoeffdingTree.FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
        HoeffdingTree.Node leafNode = foundNode.node;
        if (leafNode == null) {
            FIMTDDActiveLearningNode newNode = this.newLearningNode();
            foundNode.parent.setChild(foundNode.parentBranch, newNode);
            newNode.setParent(foundNode.parent);
            leafNode = newNode;
            ++this.activeLeafNodeCount;
        }
        if (leafNode instanceof FIMTDDActiveLearningNode) {
            FIMTDDActiveLearningNode currentNode = (FIMTDDActiveLearningNode)leafNode;
            Double leafError = currentNode.getPHError(inst) - this.PageHinckleyAlphaOption.getValue();
            for (FIMTDDSplitNode parent = (FIMTDDSplitNode)currentNode.getParent(); parent != null && this.Adaptable; parent = (FIMTDDSplitNode)parent.getParent()) {
                if (!parent.PageHinckleyTest(leafError, this.PageHinckleyThresholdOption.getValue()) || this.nodesToAdapt.contains(parent)) continue;
                this.nodesToAdapt.add(parent);
                this.nodesToAdapt.remove(parent.getChild(parent.instanceChildIndex(inst)));
            }
        }
        if (this.nodesToAdapt.size() > 0 && this.Adaptable) {
            for (int i = 0; i < this.nodesToAdapt.size(); ++i) {
                this.nodesToAdapt.get(i).learnFromInstance(inst, this, true);
            }
        } else if (leafNode instanceof HoeffdingTree.LearningNode) {
            FIMTDDActiveLearningNode activeLearningNode;
            double weightSeen;
            HoeffdingTree.LearningNode learningNode = (HoeffdingTree.LearningNode)leafNode;
            learningNode.learnFromInstance(inst, this);
            if (this.growthAllowed && learningNode instanceof FIMTDDActiveLearningNode && (weightSeen = (activeLearningNode = (FIMTDDActiveLearningNode)learningNode).getWeightSeen()) - activeLearningNode.getWeightSeenAtLastSplitEvaluation() >= (double)this.gracePeriodOption.getValue()) {
                this.FIMTDD_attemptToSplit(activeLearningNode, (FIMTDDSplitNode)foundNode.parent, foundNode.parentBranch);
                activeLearningNode.setWeightSeenAtLastSplitEvaluation(weightSeen);
            }
        }
    }

    protected void FIMTDD_attemptToSplit(FIMTDDActiveLearningNode node, FIMTDDSplitNode parent, int parentIndex) {
        SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
        Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, this);
        Arrays.sort(bestSplitSuggestions);
        boolean shouldSplit = false;
        if (bestSplitSuggestions.length < 2) {
            shouldSplit = bestSplitSuggestions.length > 0;
        } else {
            double hoeffdingBound = FIMTDD.computeHoeffdingBound(1.0, this.splitConfidenceOption.getValue(), node.getWeightSeen());
            Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            this.splitRatioStatistics.addToValue(0, 1.0);
            this.splitRatioStatistics.addToValue(1, ((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit);
            if (this.splitRatioStatistics.getValue(1) / this.splitRatioStatistics.getValue(0) + hoeffdingBound < 1.0 || hoeffdingBound < this.tieThresholdOption.getValue()) {
                shouldSplit = true;
            } else {
                for (int i = 0; i < node.attributeObservers.size(); ++i) {
                    AttributeClassObserver obs = (AttributeClassObserver)node.attributeObservers.get(i);
                    if (obs == null) continue;
                    ((FIMTDDNumericAttributeClassObserver)obs).removeBadSplits(splitCriterion, ((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit, ((AttributeSplitSuggestion)bestSuggestion).merit, hoeffdingBound);
                }
            }
            if (this.removePoorAttsOption != null && this.removePoorAttsOption.isSet()) {
                int[] splitAtts;
                int i;
                HashSet<Integer> poorAtts = new HashSet<Integer>();
                for (i = 0; i < bestSplitSuggestions.length; ++i) {
                    if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit / ((AttributeSplitSuggestion)secondBestSuggestion).merit + hoeffdingBound < 1.0)) continue;
                    poorAtts.add(new Integer(splitAtts[0]));
                }
                for (i = 0; i < bestSplitSuggestions.length; ++i) {
                    if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit / ((AttributeSplitSuggestion)secondBestSuggestion).merit + hoeffdingBound < 1.0)) continue;
                    poorAtts.remove(new Integer(splitAtts[0]));
                }
                Iterator i$ = poorAtts.iterator();
                while (i$.hasNext()) {
                    int poorAtt = (Integer)i$.next();
                    node.disableAttribute(poorAtt);
                }
            }
        }
        if (shouldSplit) {
            Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            if (((AttributeSplitSuggestion)splitDecision).splitTest == null) {
                this.deactivateLearningNode(node, parent, parentIndex);
            } else {
                FIMTDDSplitNode newSplit = this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest, node.getObservedClassDistribution());
                for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                    FIMTDDActiveLearningNode newChild = this.newLearningNode(((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i));
                    newChild.learningModel = new FIMTDDPerceptron(node.learningModel);
                    newChild.setParent(newSplit);
                    newSplit.setChild(i, newChild);
                }
                --this.activeLeafNodeCount;
                ++this.decisionNodeCount;
                this.activeLeafNodeCount += ((AttributeSplitSuggestion)splitDecision).numSplits();
                if (parent == null) {
                    this.treeRoot = newSplit;
                } else {
                    parent.setChild(parentIndex, newSplit);
                    newSplit.setParent(parent);
                }
            }
            this.enforceTrackerLimit();
        }
    }

    @Override
    protected FIMTDDActiveLearningNode newLearningNode() {
        return this.newLearningNode(new double[0]);
    }

    @Override
    protected FIMTDDActiveLearningNode newLearningNode(double[] initialClassObservations) {
        return new FIMTDDActiveLearningNode(initialClassObservations);
    }

    @Override
    protected FIMTDDSplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
        return new FIMTDDSplitNode(splitTest, classObservations);
    }

    public static class FIMTDDPerceptron
    extends AbstractMOAObject {
        protected double[] weightAttribute;
        protected DoubleVector attributeStatistics = new DoubleVector();
        protected DoubleVector squaredAttributeStatistics = new DoubleVector();
        protected int instancesSeen = 0;
        protected boolean reset;

        @Override
        public void getDescription(StringBuilder sb, int indent) {
        }

        public FIMTDDPerceptron(FIMTDDPerceptron copy) {
            this.weightAttribute = copy.getWeights();
        }

        public FIMTDDPerceptron() {
            this.reset = true;
        }

        public void setWeights(double[] w) {
            this.weightAttribute = w;
        }

        public double[] getWeights() {
            return this.weightAttribute;
        }

        public void resetLearningImpl() {
            this.reset = true;
        }

        public void trainOnInstanceImpl(Instance inst, FIMTDD ft) {
            int j;
            if (this.reset) {
                this.reset = false;
                this.weightAttribute = new double[inst.numAttributes()];
                this.instancesSeen = 0;
                this.attributeStatistics = new DoubleVector();
                this.squaredAttributeStatistics = new DoubleVector();
                for (j = 0; j < inst.numAttributes(); ++j) {
                    this.weightAttribute[j] = 2.0 * Math.random() - 1.0;
                }
            }
            ++this.instancesSeen;
            for (j = 0; j < inst.numAttributes() - 1; ++j) {
                this.attributeStatistics.addToValue(j, inst.value(j));
                this.squaredAttributeStatistics.addToValue(j, inst.value(j) * inst.value(j));
            }
            double learningRatio = 0.0;
            learningRatio = ft.learningRatio_Decay_or_Const_Option.isSet() ? ft.learningRatioOption.getValue() : ft.initLearnRate / (1.0 + (double)this.instancesSeen * ft.learnRateDecay);
            double actualClass = inst.classValue();
            double predictedClass = this.prediction(inst);
            double delta = actualClass - predictedClass;
            for (int j2 = 0; j2 < inst.numAttributes() - 1; ++j2) {
                if (!inst.attribute(j2).isNumeric()) continue;
                double sd = Math.sqrt((this.squaredAttributeStatistics.getValue(j2) - this.attributeStatistics.getValue(j2) * this.attributeStatistics.getValue(j2) / (double)this.instancesSeen) / (double)this.instancesSeen);
                double instanceValue = 0.0;
                if (sd > 1.0E-7) {
                    instanceValue = (inst.value(j2) - this.attributeStatistics.getValue(j2) / (double)this.instancesSeen) / (3.0 * sd);
                }
                int n = j2;
                this.weightAttribute[n] = this.weightAttribute[n] + learningRatio * delta * instanceValue;
            }
            int n = inst.numAttributes() - 1;
            this.weightAttribute[n] = this.weightAttribute[n] + learningRatio * delta;
        }

        public double prediction(Instance inst) {
            double prediction = 0.0;
            if (!this.reset) {
                for (int j = 0; j < inst.numAttributes() - 1; ++j) {
                    if (!inst.attribute(j).isNumeric()) continue;
                    prediction += this.weightAttribute[j] * inst.value(j);
                }
                prediction += this.weightAttribute[inst.numAttributes() - 1];
            }
            return (double)Math.round(prediction * 1000.0) / 1000.0;
        }
    }

    public static class FIMTDDSplitNode
    extends HoeffdingTree.SplitNode
    implements AdaptationCompatibleNode {
        protected HoeffdingTree.Node parent;
        protected double PHmT = 0.0;
        protected double PHMT = Double.MAX_VALUE;
        protected FIMTDD alternateTree;
        protected DoubleVector lossStatistics = new DoubleVector();
        protected int weightSeen = 0;
        protected int previousWeight = 0;

        public FIMTDDSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
            super(splitTest, classObservations);
        }

        @Override
        public void setParent(HoeffdingTree.Node parent) {
            this.parent = parent;
        }

        @Override
        public HoeffdingTree.Node getParent() {
            return this.parent;
        }

        public boolean PageHinckleyTest(double error, double threshold) {
            this.PHmT += error;
            if (this.PHmT < this.PHMT) {
                this.PHMT = this.PHmT;
            }
            return this.PHmT - this.PHMT > threshold;
        }

        public void learnFromInstance(Instance inst, FIMTDD ht, boolean growingAltTree) {
            int childBranch;
            HoeffdingTree.Node child;
            if (growingAltTree) {
                ++this.weightSeen;
                if (this.alternateTree == null) {
                    this.alternateTree = (FIMTDD)ht.copy();
                    this.alternateTree.resetLearningImpl();
                    this.alternateTree.Adaptable = false;
                    this.lossStatistics.setValue(0, 0.0);
                    this.lossStatistics.setValue(1, 0.0);
                    this.weightSeen = 0;
                    this.previousWeight = 0;
                } else if (this.weightSeen - this.previousWeight >= ht.AlternateTreeTMinOption.getValue()) {
                    this.previousWeight = this.weightSeen;
                    HoeffdingTree.FoundNode foundNode = this.alternateTree.treeRoot.filterInstanceToLeaf(inst, null, -1);
                    HoeffdingTree.Node leaf = foundNode.node;
                    double squaresAlternate = 0.0;
                    if (leaf instanceof FIMTDDActiveLearningNode) {
                        squaresAlternate = ((FIMTDDActiveLearningNode)leaf).getSquaredError();
                    }
                    foundNode = this.getChild(this.instanceChildIndex(inst)).filterInstanceToLeaf(inst, null, -1);
                    leaf = foundNode.node;
                    double squaresOriginal = 0.0;
                    if (leaf instanceof FIMTDDActiveLearningNode) {
                        squaresOriginal = ((FIMTDDActiveLearningNode)leaf).getSquaredError();
                    }
                    double Qi = Math.log(squaresOriginal / squaresAlternate);
                    double previousQiAverage = this.lossStatistics.getValue(1) / this.lossStatistics.getValue(0);
                    this.lossStatistics.addToValue(0, 1.0);
                    this.lossStatistics.addToValue(1, Qi);
                    double QiAverage = this.lossStatistics.getValue(1) / this.lossStatistics.getValue(0);
                    if (Qi > 0.0) {
                        FIMTDDSplitNode parent = (FIMTDDSplitNode)this.parent;
                        if (parent != null) {
                            parent.setChild(parent.instanceChildIndex(inst), this.alternateTree.treeRoot);
                            ht.nodesToAdapt.remove(this);
                            this.alternateTree = null;
                        } else {
                            ht = this.alternateTree;
                            ht.nodesToAdapt = new ArrayList();
                            ht.Adaptable = true;
                            this.alternateTree = null;
                        }
                    } else if (QiAverage < previousQiAverage && this.lossStatistics.getValue(0) >= (double)(10 * ht.AlternateTreeTMinOption.getValue()) || this.weightSeen >= ht.AlternateTreeTimeOption.getValue()) {
                        ht.nodesToAdapt.remove(ht.nodesToAdapt.indexOf(this));
                        this.alternateTree = null;
                    }
                }
                if (this.alternateTree != null) {
                    this.alternateTree.trainOnInstanceImpl(inst);
                }
            }
            if ((child = this.getChild(childBranch = this.instanceChildIndex(inst))) != null) {
                if (child instanceof FIMTDDActiveLearningNode) {
                    ((FIMTDDActiveLearningNode)child).learnFromInstance(inst, ht);
                } else {
                    ((FIMTDDSplitNode)child).learnFromInstance(inst, ht, false);
                }
            }
        }
    }

    public static class FIMTDDActiveLearningNode
    extends HoeffdingTree.ActiveLearningNode
    implements AdaptationCompatibleNode {
        public FIMTDDPerceptron learningModel = new FIMTDDPerceptron();
        protected HoeffdingTree.Node parent;
        protected DoubleVector nodeStatistics;
        protected double PHmT = 0.0;
        protected double PHMT = Double.MAX_VALUE;

        public FIMTDDActiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
            this.learningModel.resetLearningImpl();
            this.nodeStatistics = new DoubleVector();
        }

        @Override
        public void setParent(HoeffdingTree.Node parent) {
            this.parent = parent;
        }

        @Override
        public HoeffdingTree.Node getParent() {
            return this.parent;
        }

        @Override
        public double getWeightSeen() {
            if (this.nodeStatistics != null) {
                return this.nodeStatistics.getValue(0);
            }
            return 0.0;
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            this.nodeStatistics.addToValue(0, 1.0);
            this.nodeStatistics.addToValue(1, inst.classValue());
            this.nodeStatistics.addToValue(2, inst.classValue() * inst.classValue());
            double sd = Math.sqrt((this.nodeStatistics.getValue(2) - this.nodeStatistics.getValue(1) * this.nodeStatistics.getValue(1) / this.nodeStatistics.getValue(0)) / this.nodeStatistics.getValue(0));
            double mean = this.nodeStatistics.getValue(1) / this.nodeStatistics.getValue(0);
            this.nodeStatistics.addToValue(3, Math.abs((inst.classValue() - mean) / sd - (this.learningModel.prediction(inst) - mean) / sd));
            this.nodeStatistics.setValue(4, Math.pow(this.getError(inst), 2.0) + this.nodeStatistics.getValue(4) * ((FIMTDD)ht).AlternateTreeFadingFactorOption.getValue());
            this.learningModel.trainOnInstanceImpl(inst, (FIMTDD)ht);
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = FIMTDD.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null && inst.attribute(instAttIndex).isNumeric()) {
                    obs = ((FIMTDD)ht).newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                if (obs == null) continue;
                ((FIMTDDNumericAttributeClassObserver)obs).observeAttributeClass(inst.value(instAttIndex), inst.classValue(), inst.weight());
            }
        }

        @Override
        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion, HoeffdingTree ht) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] nodeSplitDist = this.nodeStatistics.getArrayCopy();
            double[] preSplitDist = this.observedClassDistribution.getArrayCopy();
            if (!ht.noPrePruneOption.isSet()) {
                bestSuggestions.add(new AttributeSplitSuggestion(null, new double[0][], criterion.getMeritOfSplit(nodeSplitDist, new double[][]{nodeSplitDist})));
            }
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null) continue;
                AttributeSplitSuggestion bestSuggestion = null;
                if (obs instanceof FIMTDDNumericAttributeClassObserver) {
                    bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, nodeSplitDist, i, ht.binarySplitsOption.isSet());
                }
                if (bestSuggestion == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        public double getPrediction(Instance inst, HoeffdingTree ht) {
            return this.learningModel.prediction(inst);
        }

        public double getPredictionTargetMean(Instance inst, HoeffdingTree ht) {
            double valor = 0.0;
            if (this.nodeStatistics.getValue(0) > 0.0) {
                valor = this.nodeStatistics.getValue(1) / this.nodeStatistics.getValue(0);
            }
            return valor;
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            double targetMeanError;
            double[] ret = new double[1];
            double perceptronPrediction = this.getPrediction(inst, ht);
            double targetMeanPrediction = this.getPredictionTargetMean(inst, ht);
            double perceptronError = Math.abs(inst.classValue() - perceptronPrediction);
            ret[0] = perceptronError < (targetMeanError = Math.abs(inst.classValue() - targetMeanPrediction)) ? perceptronPrediction : targetMeanPrediction;
            return ret;
        }

        public double getError(Instance inst) {
            return inst.classValue() - this.learningModel.prediction(inst);
        }

        public double getPHError(Instance inst) {
            double sd = Math.sqrt((this.nodeStatistics.getValue(2) - this.nodeStatistics.getValue(1) * this.nodeStatistics.getValue(1) / this.nodeStatistics.getValue(0)) / this.nodeStatistics.getValue(0));
            double mean = this.nodeStatistics.getValue(1) / this.nodeStatistics.getValue(0);
            return Math.abs((inst.classValue() - mean) / sd - (this.learningModel.prediction(inst) - mean) / sd) - (this.nodeStatistics.getValue(3) + Math.abs((inst.classValue() - mean) / sd - (this.learningModel.prediction(inst) - mean) / sd)) / (this.nodeStatistics.getValue(0) + 1.0);
        }

        public double getSquaredError() {
            return this.nodeStatistics.getValue(4);
        }
    }

    public static interface AdaptationCompatibleNode {
        public void setParent(HoeffdingTree.Node var1);

        public HoeffdingTree.Node getParent();
    }
}

