/*
 * Decompiled with CFR 0.152.
 */
package moa.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import moa.AbstractMOAObject;
import weka.core.Instance;

public abstract class Cluster
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    private double id = -1.0;
    private double gtLabel = -1.0;
    private HashMap<String, String> measure_values = new HashMap();

    public abstract double[] getCenter();

    public abstract double getWeight();

    public abstract double getInclusionProbability(Instance var1);

    @Override
    public void getDescription(StringBuilder sb, int i) {
        sb.append("Cluster Object");
    }

    public void setId(double id) {
        this.id = id;
    }

    public double getId() {
        return this.id;
    }

    public boolean isGroundTruth() {
        return this.gtLabel != -1.0;
    }

    public void setGroundTruth(double truth) {
        this.gtLabel = truth;
    }

    public double getGroundTruth() {
        return this.gtLabel;
    }

    public abstract Instance sample(Random var1);

    public void setMeasureValue(String measureKey, String value) {
        this.measure_values.put(measureKey, value);
    }

    public void setMeasureValue(String measureKey, double value) {
        this.measure_values.put(measureKey, Double.toString(value));
    }

    public String getMeasureValue(String measureKey) {
        if (this.measure_values.containsKey(measureKey)) {
            return this.measure_values.get(measureKey);
        }
        return "";
    }

    protected void getClusterSpecificInfo(ArrayList<String> infoTitle, ArrayList<String> infoValue) {
        infoTitle.add("ClusterID");
        infoValue.add(Integer.toString((int)this.getId()));
        infoTitle.add("Type");
        infoValue.add(this.getClass().getSimpleName());
        double[] c = this.getCenter();
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                infoTitle.add("Dim" + i);
                infoValue.add(Double.toString(c[i]));
            }
        }
        infoTitle.add("Weight");
        infoValue.add(Double.toString(this.getWeight()));
    }

    public String getInfo() {
        ArrayList<String> infoTitle = new ArrayList<String>();
        ArrayList<String> infoValue = new ArrayList<String>();
        this.getClusterSpecificInfo(infoTitle, infoValue);
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<table>");
        for (int i = 0; i < infoTitle.size() && i < infoValue.size(); ++i) {
            sb.append("<tr><td>" + infoTitle.get(i) + "</td><td>" + infoValue.get(i) + "</td></tr>");
        }
        sb.append("</table>");
        sb.append("<br>");
        sb.append("<b>Evaluation</b><br>");
        sb.append("<table>");
        for (Map.Entry<String, String> e : this.measure_values.entrySet()) {
            sb.append("<tr><td>" + e.getKey() + "</td><td>" + e.getValue() + "</td></tr>");
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }
}

