/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import moa.gui.OptionEditComponent;
import moa.options.Option;
import moa.options.WEKAClassOption;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;

public class WEKAClassOptionEditComponent
extends JPanel
implements OptionEditComponent {
    private static final long serialVersionUID = 1L;
    protected WEKAClassOption editedOption;
    protected JTextField textField = new JTextField();
    protected JButton editButton = new JButton("Edit");

    public WEKAClassOptionEditComponent(WEKAClassOption option) {
        this.editedOption = option;
        this.textField.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.editButton, "East");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WEKAClassOptionEditComponent.this.editObject();
            }
        });
        this.setEditState(this.editedOption.getValueAsCLIString());
    }

    @Override
    public void applyState() {
        this.editedOption.setValueViaCLIString(this.textField.getText());
    }

    @Override
    public Option getEditedOption() {
        return this.editedOption;
    }

    @Override
    public void setEditState(String cliString) {
        this.textField.setText(cliString);
    }

    public void editObject() {
        final GenericObjectEditor goe = new GenericObjectEditor(true);
        goe.setClassType(this.editedOption.getRequiredType());
        try {
            String[] options = Utils.splitOptions((String)this.editedOption.getValueAsCLIString());
            String classname = options[0];
            options[0] = "";
            Object obj = Class.forName(classname).newInstance();
            if (obj instanceof OptionHandler) {
                ((OptionHandler)obj).setOptions(options);
            }
            goe.setValue(obj);
            ((GenericObjectEditor.GOEPanel)goe.getCustomEditor()).addOkListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = goe.getValue();
                    String s = obj.getClass().getName();
                    if (obj instanceof OptionHandler) {
                        s = s + " " + Utils.joinOptions((String[])((OptionHandler)obj).getOptions());
                    }
                    WEKAClassOptionEditComponent.this.setEditState(s.trim());
                }
            });
            PropertyDialog dialog = PropertyDialog.getParentDialog((Container)this) != null ? new PropertyDialog(PropertyDialog.getParentDialog((Container)this), (PropertyEditor)goe) : new PropertyDialog(PropertyDialog.getParentFrame((Container)this), (PropertyEditor)goe);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

