/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.utils;

public class ColorConversion {
    public static void rgb2hsv(int r, int g, int b, int[] hsv) {
        int min = Math.min(r, g);
        min = Math.min(min, b);
        int max = Math.max(r, g);
        max = Math.max(max, b);
        int delMax = max - min;
        float H = 0.0f;
        float S = 0.0f;
        float V = (float)max / 255.0f;
        if (delMax == 0) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = (float)delMax / 255.0f;
            if (r == max) {
                H = g >= b ? ((float)g / 255.0f - (float)b / 255.0f) / (float)delMax / 255.0f * 60.0f : ((float)g / 255.0f - (float)b / 255.0f) / (float)delMax / 255.0f * 60.0f + 360.0f;
            } else if (g == max) {
                H = (2.0f + ((float)b / 255.0f - (float)r / 255.0f) / (float)delMax / 255.0f) * 60.0f;
            } else if (b == max) {
                H = (4.0f + ((float)r / 255.0f - (float)g / 255.0f) / (float)delMax / 255.0f) * 60.0f;
            }
        }
        hsv[0] = (int)H;
        hsv[1] = (int)(S * 100.0f);
        hsv[2] = (int)(V * 100.0f);
    }
}

