/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexing.parallel;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.DocumentBuilderFactory;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import net.semanticmetadata.lire.imageanalysis.SimpleColorHistogram;
import net.semanticmetadata.lire.imageanalysis.joint.JointHistogram;
import net.semanticmetadata.lire.impl.ChainedDocumentBuilder;
import net.semanticmetadata.lire.impl.GenericDocumentBuilder;
import net.semanticmetadata.lire.indexing.LireCustomCodec;
import net.semanticmetadata.lire.indexing.parallel.WorkItem;
import net.semanticmetadata.lire.utils.FileUtils;
import net.semanticmetadata.lire.utils.LuceneUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class ParallelIndexer
implements Runnable {
    private int numberOfThreads = 10;
    private String indexPath;
    private String imageDirectory;
    Stack<WorkItem> images = new Stack();
    IndexWriter writer;
    File imageList = null;
    boolean ended = false;
    boolean threadFinished = false;
    private List<String> files;
    int overallCount = 0;
    int numImages = -1;
    private IndexWriterConfig.OpenMode openMode = IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
    private int monitoringInterval = 30;

    public static void main(String[] args) {
        String indexPath = null;
        String imageDirectory = null;
        File imageList = null;
        int numThreads = 10;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i")) {
                if (i + 1 >= args.length) continue;
                indexPath = args[i + 1];
                continue;
            }
            if (arg.startsWith("-n")) {
                if (i + 1 >= args.length) continue;
                try {
                    numThreads = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not read number of threads: " + args[i + 1] + "\nUsing default value " + numThreads);
                }
                continue;
            }
            if (arg.startsWith("-l")) {
                imageDirectory = null;
                if (i + 1 >= args.length || (imageList = new File(args[i + 1])).exists()) continue;
                System.err.println(args[i + 1] + " does not exits!");
                ParallelIndexer.printHelp();
                System.exit(-1);
                continue;
            }
            if (!arg.startsWith("-d") || i + 1 >= args.length) continue;
            imageDirectory = args[i + 1];
        }
        if (indexPath == null) {
            ParallelIndexer.printHelp();
            System.exit(-1);
        } else if (!(imageList != null || imageDirectory != null && new File(imageDirectory).exists())) {
            ParallelIndexer.printHelp();
            System.exit(-1);
        }
        ParallelIndexer p = imageList != null ? new ParallelIndexer(numThreads, indexPath, imageList){

            @Override
            public void addBuilders(ChainedDocumentBuilder builder) {
                builder.addBuilder(new GenericDocumentBuilder(PHOG.class, "featPHOG", true));
                builder.addBuilder(new GenericDocumentBuilder(JCD.class, "featureJCD", true));
                builder.addBuilder(new GenericDocumentBuilder(OpponentHistogram.class, "featOpHist", true));
                builder.addBuilder(new GenericDocumentBuilder(JointHistogram.class, "featureJointHist", true));
                builder.addBuilder(new GenericDocumentBuilder(ColorLayout.class, "descriptorColorLayout", true));
                builder.addBuilder(new GenericDocumentBuilder(EdgeHistogram.class, "descriptorEdgeHistogram", true));
                builder.addBuilder(new GenericDocumentBuilder(SimpleColorHistogram.class, "featureColorHistogram", true));
            }
        } : new ParallelIndexer(numThreads, indexPath, imageDirectory){

            @Override
            public void addBuilders(ChainedDocumentBuilder builder) {
                builder.addBuilder(new GenericDocumentBuilder(PHOG.class, "featPHOG", true));
                builder.addBuilder(new GenericDocumentBuilder(JCD.class, "featureJCD", true));
                builder.addBuilder(new GenericDocumentBuilder(OpponentHistogram.class, "featOpHist", true));
                builder.addBuilder(new GenericDocumentBuilder(JointHistogram.class, "featureJointHist", true));
                builder.addBuilder(new GenericDocumentBuilder(ColorLayout.class, "descriptorColorLayout", true));
                builder.addBuilder(new GenericDocumentBuilder(EdgeHistogram.class, "descriptorEdgeHistogram", true));
                builder.addBuilder(new GenericDocumentBuilder(SimpleColorHistogram.class, "featureColorHistogram", true));
            }
        };
        p.run();
    }

    private static void printHelp() {
        System.out.println("Usage:\n\n$> ParallelIndexer -i <index> <-d <image-directory> | -l <image-list>> [-n <number of threads>]\n\nindex             ... The directory of the index. Will be appended or created if not existing.\nimages-directory  ... The directory the images are found in. It's traversed recursively.\nimage-list        ... A list of images in a file, one per line. Use instead of images-directory.\nnumber of threads ... The number of threads used for extracting features, e.g. # of CPU cores.");
    }

    public ParallelIndexer(int numberOfThreads, String indexPath, String imageDirectory) {
        this.numberOfThreads = numberOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
    }

    public ParallelIndexer(int numberOfThreads, String indexPath, String imageDirectory, boolean overWrite) {
        this.numberOfThreads = numberOfThreads;
        this.indexPath = indexPath;
        this.imageDirectory = imageDirectory;
        if (overWrite) {
            this.openMode = IndexWriterConfig.OpenMode.CREATE;
        }
    }

    public ParallelIndexer(int numberOfThreads, String indexPath, File imageList) {
        this.numberOfThreads = numberOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
    }

    public ParallelIndexer(int numberOfThreads, String indexPath, File imageList, boolean overWrite) {
        this.numberOfThreads = numberOfThreads;
        this.indexPath = indexPath;
        this.imageList = imageList;
        if (overWrite) {
            this.openMode = IndexWriterConfig.OpenMode.CREATE;
        }
    }

    public void addBuilders(ChainedDocumentBuilder builder) {
        builder.addBuilder(DocumentBuilderFactory.getCEDDDocumentBuilder());
        builder.addBuilder(DocumentBuilderFactory.getFCTHDocumentBuilder());
        builder.addBuilder(DocumentBuilderFactory.getJCDDocumentBuilder());
        builder.addBuilder(DocumentBuilderFactory.getPHOGDocumentBuilder());
        builder.addBuilder(DocumentBuilderFactory.getOpponentHistogramDocumentBuilder());
        builder.addBuilder(DocumentBuilderFactory.getJointHistogramDocumentBuilder());
        builder.addBuilder(DocumentBuilderFactory.getColorLayoutBuilder());
        builder.addBuilder(DocumentBuilderFactory.getEdgeHistogramBuilder());
    }

    @Override
    public void run() {
        IndexWriterConfig config = new IndexWriterConfig(LuceneUtils.LUCENE_VERSION, (Analyzer)new StandardAnalyzer(LuceneUtils.LUCENE_VERSION));
        config.setOpenMode(this.openMode);
        config.setCodec((Codec)new LireCustomCodec());
        try {
            if (this.imageDirectory != null) {
                System.out.println("Getting all images in " + this.imageDirectory + ".");
            }
            this.writer = new IndexWriter((Directory)FSDirectory.open((File)new File(this.indexPath)), config);
            if (this.imageList == null) {
                this.files = FileUtils.getAllImages(new File(this.imageDirectory), true);
            } else {
                this.files = new LinkedList<String>();
                BufferedReader br = new BufferedReader(new FileReader(this.imageList));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.trim().length() <= 3) continue;
                    this.files.add(line.trim());
                }
            }
            this.numImages = this.files.size();
            System.out.println("Indexing " + this.files.size() + " images.");
            Thread p = new Thread(new Producer());
            p.start();
            LinkedList<Thread> threads = new LinkedList<Thread>();
            long l = System.currentTimeMillis();
            for (int i = 0; i < this.numberOfThreads; ++i) {
                Thread c = new Thread(new Consumer());
                c.start();
                threads.add(c);
            }
            Thread m = new Thread(new Monitoring());
            m.start();
            Iterator iterator = threads.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).join();
            }
            long l1 = System.currentTimeMillis() - l;
            System.out.println("Analyzed " + this.overallCount + " images in " + l1 / 1000L + " seconds, ~" + (this.overallCount > 0 ? Long.valueOf(l1 / (long)this.overallCount) : "n.a.") + " ms each.");
            this.writer.commit();
            this.writer.close();
            this.threadFinished = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean hasEnded() {
        return this.threadFinished;
    }

    public double getPercentageDone() {
        return (double)this.overallCount / (double)this.numImages;
    }

    class Consumer
    implements Runnable {
        WorkItem tmp = null;
        ChainedDocumentBuilder builder = new ChainedDocumentBuilder();
        int count = 0;
        boolean locallyEnded = false;

        Consumer() {
            ParallelIndexer.this.addBuilders(this.builder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.locallyEnded) {
                Stack<WorkItem> stack = ParallelIndexer.this.images;
                synchronized (stack) {
                    while (ParallelIndexer.this.images.empty() && !ParallelIndexer.this.ended) {
                        try {
                            ParallelIndexer.this.images.wait(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (ParallelIndexer.this.images.empty() && ParallelIndexer.this.ended) {
                        this.locallyEnded = true;
                    }
                    if (!ParallelIndexer.this.images.empty() && !this.locallyEnded) {
                        this.tmp = ParallelIndexer.this.images.pop();
                        ++this.count;
                        ++ParallelIndexer.this.overallCount;
                    }
                }
                try {
                    if (this.locallyEnded) continue;
                    ByteArrayInputStream b = new ByteArrayInputStream(this.tmp.getBuffer());
                    BufferedImage img = ImageIO.read(b);
                    Document d = this.builder.createDocument(img, this.tmp.getFileName());
                    ParallelIndexer.this.writer.addDocument((Iterable)d);
                }
                catch (Exception e) {
                    System.err.println("[ParallelIndexer] Could not handle file " + this.tmp.getFileName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    class Producer
    implements Runnable {
        Producer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean leaveOneOut = false;
            int tmpSize = 0;
            for (String path : ParallelIndexer.this.files) {
                File next = new File(path);
                try {
                    int fileSize = (int)next.length();
                    byte[] buffer = new byte[fileSize];
                    FileInputStream fis = new FileInputStream(next);
                    fis.read(buffer);
                    Stack<WorkItem> stack = ParallelIndexer.this.images;
                    synchronized (stack) {
                        path = next.getCanonicalPath();
                        if (ParallelIndexer.this.images.size() > 500) {
                            ParallelIndexer.this.images.wait(5000L);
                        }
                        ParallelIndexer.this.images.add(new WorkItem(path, buffer));
                        tmpSize = ParallelIndexer.this.images.size();
                        ParallelIndexer.this.images.notifyAll();
                    }
                    try {
                        if (tmpSize > 500) {
                            Thread.sleep(50L);
                            continue;
                        }
                        if (tmpSize > 1000) {
                            Thread.sleep(5000L);
                            continue;
                        }
                        if (tmpSize > 2000) {
                            Thread.sleep(50000L);
                            continue;
                        }
                        if (tmpSize > 3000) {
                            Thread.sleep(500000L);
                            continue;
                        }
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.err.println("Could not open " + path + ". " + e.getMessage());
                }
            }
            Stack<WorkItem> stack = ParallelIndexer.this.images;
            synchronized (stack) {
                ParallelIndexer.this.ended = true;
                ParallelIndexer.this.images.notifyAll();
            }
        }
    }

    class Monitoring
    implements Runnable {
        Monitoring() {
        }

        @Override
        public void run() {
            long ms = System.currentTimeMillis();
            try {
                Thread.sleep(1000 * ParallelIndexer.this.monitoringInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (!ParallelIndexer.this.ended) {
                try {
                    long time = System.currentTimeMillis() - ms;
                    System.out.println("Analyzed " + ParallelIndexer.this.overallCount + " images in " + time / 1000L + " seconds, " + (ParallelIndexer.this.overallCount > 0 ? Long.valueOf(time / (long)ParallelIndexer.this.overallCount) : "n.a.") + " ms each (" + ParallelIndexer.this.images.size() + " images currently in queue).");
                    Thread.sleep(1000 * ParallelIndexer.this.monitoringInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

