/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.base.BasePassword;
import adams.core.net.TwitterHelper;
import adams.flow.standalone.AbstractStandalone;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterConnection
extends AbstractStandalone {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_ConsumerKey;
    protected BasePassword m_ConsumerSecret;
    protected String m_AccessToken;
    protected BasePassword m_AccessTokenSecret;

    public String globalInfo() {
        return "Provides access to various twitter services.\nFor your own twitter account, you can obtain consumer key and access token for ADAMS (= application trying to access twitter) here:\n  https://dev.twitter.com/apps/\nAnd make sure that ADAMS has READ and WRITER access.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("consumer-key", "consumerKey", (Object)TwitterHelper.getConsumerKey());
        this.m_OptionManager.add("consumer-secret", "consumerSecret", (Object)TwitterHelper.getConsumerSecret());
        this.m_OptionManager.add("access-token", "accessToken", (Object)TwitterHelper.getAccessToken());
        this.m_OptionManager.add("acces-token-secret", "accessTokenSecret", (Object)TwitterHelper.getAccessTokenSecret());
    }

    public void setConsumerKey(String value) {
        this.m_ConsumerKey = value;
        this.reset();
    }

    public String getConsumerKey() {
        return this.m_ConsumerKey;
    }

    public String consumerKeyTipText() {
        return "The twitter consumer key to use for connecting; leave empty for anonymous access.";
    }

    public void setConsumerSecret(BasePassword value) {
        this.m_ConsumerSecret = value;
        this.reset();
    }

    public BasePassword getConsumerSecret() {
        return this.m_ConsumerSecret;
    }

    public String consumerSecretTipText() {
        return "The consumer secret of the twitter application to use for connecting.";
    }

    public void setAccessToken(String value) {
        this.m_AccessToken = value;
        this.reset();
    }

    public String getAccessToken() {
        return this.m_AccessToken;
    }

    public String accessTokenTipText() {
        return "The twitter access token to use for connecting.";
    }

    public void setAccessTokenSecret(BasePassword value) {
        this.m_AccessTokenSecret = value;
        this.reset();
    }

    public BasePassword getAccessTokenSecret() {
        return this.m_AccessTokenSecret;
    }

    public String accessTokenSecretTipText() {
        return "The access token secret of the twitter application to use for connecting.";
    }

    public Configuration getConfiguration() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setOAuthConsumerKey(this.getConsumerKey());
        cb.setOAuthConsumerSecret(this.getConsumerSecret().getValue());
        cb.setOAuthAccessToken(this.getAccessToken());
        cb.setOAuthAccessTokenSecret(this.getAccessTokenSecret().getValue());
        return cb.build();
    }

    public Twitter getTwitterConnection() {
        return new TwitterFactory(this.getConfiguration()).getInstance();
    }

    public TwitterStream getTwitterStreamConnection() {
        return new TwitterStreamFactory(this.getConfiguration()).getInstance();
    }

    protected String doExecute() {
        return null;
    }
}

