/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class AccessDatabaseInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = -8104727186480376733L;
    protected InfoType m_Type;
    protected String m_Table;
    protected boolean m_Sort;

    public String globalInfo() {
        return "Outputs information on a MS Access database.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.TABLES);
        this.m_OptionManager.add("table", "table", (Object)"MyTable");
        this.m_OptionManager.add("sort", "sort", (Object)true);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.TABLES));
        if (types.contains((Object)this.m_Type) || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type")) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sort", (boolean)this.m_Sort, (String)(this.m_Sort ? "sorted" : "unsorted"), (String)", ");
        }
        return result;
    }

    public String outputArrayTipText() {
        return "Outputs the information as an array instead of one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        return "The table to read from the database.";
    }

    public void setSort(boolean value) {
        this.m_Sort = value;
        this.reset();
    }

    public boolean getSort() {
        return this.m_Sort;
    }

    public String sortTipText() {
        return "If enabled, lists (eg names, values) are sorted.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case FILE: 
            case FILE_FORMAT: 
            case TABLES: 
            case COLUMN_ORDER: 
            case COLUMN_NAMES: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        Database db = null;
        try {
            db = DatabaseBuilder.open((File)file.getAbsoluteFile());
            switch (this.m_Type) {
                case FILE: {
                    this.m_Queue.add(db.getFile().toString());
                    return result;
                }
                case FILE_FORMAT: {
                    this.m_Queue.add(db.getFileFormat().toString());
                    return result;
                }
                case TABLES: {
                    this.m_Queue.addAll(db.getTableNames());
                    if (!this.m_Sort) return result;
                    Collections.sort(this.m_Queue);
                    return result;
                }
                case COLUMN_ORDER: {
                    this.m_Queue.add(db.getColumnOrder().toString());
                    return result;
                }
                case COLUMN_NAMES: {
                    Table table = db.getTable(this.m_Table);
                    if (table != null) {
                        for (Column col : table.getColumns()) {
                            this.m_Queue.add(col.getName());
                        }
                        return result;
                    } else {
                        result = "Table '" + this.m_Table + "' not found?";
                        return result;
                    }
                }
                default: {
                    throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed process database: " + file, e);
            return result;
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static enum InfoType {
        FILE,
        FILE_FORMAT,
        TABLES,
        COLUMN_ORDER,
        COLUMN_NAMES;

    }
}

