/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.StreamUtil;
import jodd.mail.CommonEmail;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailUtil;
import jodd.mail.MailException;
import jodd.mail.att.ByteArrayAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivedEmail
extends CommonEmail {
    protected Flags flags;
    protected int messageNumber;
    protected Date recvDate;
    protected List<EmailAttachment> attachments;
    protected List<ReceivedEmail> attachedMessages;

    public ReceivedEmail() {
    }

    public ReceivedEmail(Message message) {
        try {
            this.parseMessage(message);
        }
        catch (Exception ex) {
            throw new MailException("Message parsing failed", ex);
        }
    }

    protected void parseMessage(Message msg) throws MessagingException, IOException {
        this.setFlags(msg.getFlags());
        this.setMessageNumber(msg.getMessageNumber());
        Address[] addresses = msg.getFrom();
        if (addresses != null && addresses.length > 0) {
            this.setFrom(addresses[0].toString());
        }
        this.setTo(EmailUtil.address2String(msg.getRecipients(Message.RecipientType.TO)));
        this.setCc(EmailUtil.address2String(msg.getRecipients(Message.RecipientType.CC)));
        this.setBcc(EmailUtil.address2String(msg.getRecipients(Message.RecipientType.BCC)));
        this.setSubject(msg.getSubject());
        Date recvDate = msg.getReceivedDate();
        if (recvDate == null) {
            recvDate = new Date();
        }
        this.setReceiveDate(recvDate);
        this.setSentDate(msg.getSentDate());
        Enumeration headers = msg.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            this.setHeader(header.getName(), header.getValue());
        }
        this.processPart(this, (Part)msg);
    }

    protected void processPart(ReceivedEmail email, Part part) throws IOException, MessagingException {
        Object content = part.getContent();
        if (content instanceof String) {
            String stringContent = (String)content;
            String disposition = part.getDisposition();
            if (disposition != null && disposition.equalsIgnoreCase("attachment")) {
                String contentId;
                String contentType = part.getContentType();
                String mimeType = EmailUtil.extractMimeType(contentType);
                String encoding = EmailUtil.extractEncoding(contentType);
                String fileName = part.getFileName();
                String string = contentId = part instanceof MimePart ? ((MimePart)part).getContentID() : null;
                if (encoding == null) {
                    encoding = "US-ASCII";
                }
                email.addAttachment(fileName, mimeType, contentId, stringContent.getBytes(encoding));
            } else {
                String contentType = part.getContentType();
                String encoding = EmailUtil.extractEncoding(contentType);
                String mimeType = EmailUtil.extractMimeType(contentType);
                if (encoding == null) {
                    encoding = "US-ASCII";
                }
                email.addMessage(stringContent, mimeType, encoding);
            }
        } else if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                BodyPart innerPart = mp.getBodyPart(i);
                this.processPart(email, (Part)innerPart);
            }
        } else if (content instanceof InputStream) {
            String fileName = part.getFileName();
            String contentId = part instanceof MimePart ? ((MimePart)part).getContentID() : null;
            String mimeType = EmailUtil.extractMimeType(part.getContentType());
            InputStream is = (InputStream)content;
            FastByteArrayOutputStream fbaos = new FastByteArrayOutputStream();
            StreamUtil.copy((InputStream)is, (OutputStream)fbaos);
            email.addAttachment(fileName, mimeType, contentId, fbaos.toByteArray());
        } else if (content instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)content;
            this.addAttachmentMessage(new ReceivedEmail((Message)mimeMessage));
        }
    }

    public Flags getFlags() {
        return this.flags;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public boolean isAnswered() {
        return this.flags.contains(Flags.Flag.ANSWERED);
    }

    public boolean isDeleted() {
        return this.flags.contains(Flags.Flag.DELETED);
    }

    public boolean isDraf() {
        return this.flags.contains(Flags.Flag.DRAFT);
    }

    public boolean isFlagged() {
        return this.flags.contains(Flags.Flag.FLAGGED);
    }

    public boolean isRecent() {
        return this.flags.contains(Flags.Flag.RECENT);
    }

    public boolean isSeen() {
        return this.flags.contains(Flags.Flag.SEEN);
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(int messageNumber) {
        this.messageNumber = messageNumber;
    }

    public void setReceiveDate(Date date) {
        this.recvDate = date;
    }

    public Date getReceiveDate() {
        return this.recvDate;
    }

    public void addAttachment(String filename, String mimeType, String contentId, byte[] content) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<EmailAttachment>();
        }
        ByteArrayAttachment emailAttachment = new ByteArrayAttachment(content, mimeType, filename, contentId);
        emailAttachment.setSize(content.length);
        this.attachments.add(emailAttachment);
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public void addAttachmentMessage(ReceivedEmail receivedEmail) {
        if (this.attachedMessages == null) {
            this.attachedMessages = new ArrayList<ReceivedEmail>();
        }
        this.attachedMessages.add(receivedEmail);
    }

    public List<ReceivedEmail> getAttachedMessages() {
        return this.attachedMessages;
    }
}

