/*
 * Decompiled with CFR 0.152.
 */
package adams.core.scripting;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.core.scripting.JythonScript;
import adams.env.Environment;
import adams.flow.core.AdditionalOptionsHandler;
import adams.flow.core.AdditionalOptionsHandlerUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public class Jython
extends LoggingObject {
    private static final long serialVersionUID = -6972298704460209252L;
    public static final String CLASS_PYTHONINERPRETER = "org.python.util.PythonInterpreter";
    public static final String CLASS_PYTHONOBJECTINPUTSTREAM = "org.python.util.PythonObjectInputStream";
    public static final String REGISTRY_FILE = ".jython";
    public static final String REGISTRY_JAVAACCESSIBILITY = "python.security.respectJavaAccessibility";
    protected boolean m_Present;
    protected Object m_Interpreter;
    protected static Jython m_Singleton;

    protected Jython() {
        try {
            Class.forName(CLASS_PYTHONINERPRETER);
            this.checkRegistry();
            this.m_Present = true;
        }
        catch (Exception e) {
            this.m_Present = false;
        }
        this.m_Interpreter = this.newInterpreter();
    }

    protected void checkRegistry() {
        File registry = new File(System.getProperty("user.home") + File.separator + REGISTRY_FILE);
        if (!registry.exists()) {
            if (!FileUtils.writeToFile((String)registry.getAbsolutePath(), (Object)"python.security.respectJavaAccessibility=false", (boolean)false)) {
                System.err.println("Failed to initialize Jython registry: " + registry);
            } else {
                System.err.println("Jython registry initialized: " + registry);
            }
        } else {
            List lines = FileUtils.loadFromFile((File)registry);
            for (int i = 0; i < lines.size(); ++i) {
                if (!((String)lines.get(i)).startsWith("python.security.respectJavaAccessibility=") || ((String)lines.get(i)).contains("=false")) continue;
                lines.set(i, "python.security.respectJavaAccessibility=false");
                if (!FileUtils.writeToFile((String)registry.getAbsolutePath(), (Object)Utils.flatten((List)lines, (String)System.getProperty("line.separator")), (boolean)false)) {
                    System.err.println("Failed to update Jython registry: " + registry);
                    break;
                }
                System.err.println("Jython registry updated: " + registry);
                break;
            }
        }
    }

    public Object getInterpreter() {
        return this.m_Interpreter;
    }

    public Object invoke(String methodName, Class[] paramClasses, Object[] paramValues) {
        Object result = null;
        if (this.getInterpreter() != null) {
            result = this.invoke(this.getInterpreter(), methodName, paramClasses, paramValues);
        }
        return result;
    }

    public boolean isPresent() {
        return this.m_Present;
    }

    public Object newInterpreter() {
        Object result = null;
        if (this.isPresent()) {
            try {
                result = Class.forName(CLASS_PYTHONINERPRETER).newInstance();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to instantiate new interpreter!", e);
                result = null;
            }
        }
        return result;
    }

    public Object newInstance(File file, Class template) {
        return this.newInstance(file, template, new File[0]);
    }

    public Object newInstance(File file, Class template, File[] paths) {
        String instanceName;
        Object result = null;
        if (!this.isPresent()) {
            return result;
        }
        Object interpreter = this.newInterpreter();
        if (interpreter == null) {
            return result;
        }
        if (paths.length > 0) {
            int i;
            this.invoke(interpreter, "exec", new Class[]{String.class}, new Object[]{"import sys"});
            instanceName = "syspath";
            this.invoke(interpreter, "exec", new Class[]{String.class}, new Object[]{instanceName + " = sys.path"});
            HashSet<String> currentPaths = new HashSet<String>();
            try {
                String[] tmpPaths = (String[])this.invoke(interpreter, "get", new Class[]{String.class, Class.class}, new Object[]{instanceName, String[].class});
                for (i = 0; i < tmpPaths.length; ++i) {
                    currentPaths.add(tmpPaths[i]);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to add additional paths!", e);
            }
            for (i = 0; i < paths.length; ++i) {
                if (currentPaths.contains(paths[i].getAbsolutePath())) continue;
                this.invoke(interpreter, "exec", new Class[]{String.class}, new Object[]{"sys.path.append('" + paths[i].getAbsolutePath() + "')"});
            }
        }
        String filename = file.getAbsolutePath();
        this.invoke(interpreter, "execfile", new Class[]{String.class}, new Object[]{filename});
        String tempName = filename.substring(filename.lastIndexOf(File.separator) + 1);
        tempName = tempName.substring(0, tempName.indexOf("."));
        instanceName = tempName.toLowerCase();
        String javaClassName = tempName.substring(0, 1).toUpperCase() + tempName.substring(1);
        String objectDef = "=" + javaClassName + "()";
        this.invoke(interpreter, "exec", new Class[]{String.class}, new Object[]{instanceName + objectDef});
        try {
            result = this.invoke(interpreter, "get", new Class[]{String.class, Class.class}, new Object[]{instanceName, template});
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate script '" + file + "' as '" + template.getName() + "'!", e);
            e.printStackTrace();
        }
        return result;
    }

    public Object invoke(Object o, String methodName, Class[] paramClasses, Object[] paramValues) {
        Object result = null;
        try {
            Method m = o.getClass().getMethod(methodName, paramClasses);
            result = m.invoke(o, paramValues);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to invoke method '" + methodName + "' (" + Utils.arrayToString((Object)paramClasses) + " with " + Utils.arrayToString((Object)paramValues) + ")!", e);
            result = null;
        }
        return result;
    }

    public Object deserialize(InputStream in) {
        Object result = null;
        try {
            Class<?> cls = Class.forName(CLASS_PYTHONOBJECTINPUTSTREAM);
            Class[] paramTypes = new Class[]{InputStream.class};
            Constructor<?> constr = cls.getConstructor(paramTypes);
            Object[] arglist = new Object[]{in};
            Object obj = constr.newInstance(arglist);
            result = this.invoke(obj, "readObject", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to deserialize stream!", e);
        }
        return result;
    }

    public Object[] loadScriptObject(Class cls, PlaceholderFile scriptFile, JythonScript inlineScript, String scriptOptions, Variables vars) {
        PlaceholderFile file;
        Object[] result;
        block16: {
            result = new Object[2];
            file = null;
            if (scriptFile.isDirectory()) {
                if (inlineScript.getValue().trim().length() == 0) {
                    result[0] = "Neither script file nor inline script provided!";
                } else {
                    try {
                        String[] lines = inlineScript.getValue().split("\n");
                        String name = null;
                        for (String line : lines) {
                            if (!line.matches("class [ ]*.*\\(.*")) continue;
                            name = line.replaceAll("class [ ]*", "").replaceAll("\\(.*", "");
                            break;
                        }
                        if (name == null) {
                            result[0] = "Failed to locate class name!";
                            break block16;
                        }
                        file = new PlaceholderFile("${TMP}/" + name + ".py");
                        FileUtils.saveToFile((String[])lines, (File)file);
                    }
                    catch (Exception e) {
                        result[0] = "Failed to save inline script to temporary file: " + Utils.throwableToString((Throwable)e);
                        this.getLogger().log(Level.SEVERE, "Failed to save inline script to temporary file!", e);
                    }
                }
            } else {
                file = scriptFile;
            }
        }
        if (result[0] == null) {
            try {
                if (file.isFile()) {
                    result[1] = this.newInstance((File)file, cls);
                    if (result[1] != null) {
                        if (!AdditionalOptionsHandlerUtils.setOptions((Object)result[1], (String)scriptOptions, (Variables)vars)) {
                            result[0] = "Does not implement '" + AdditionalOptionsHandler.class.getName() + "': " + file;
                        }
                    } else {
                        result[0] = "Failed to instantiate script '" + file + "'!";
                    }
                } else {
                    result[0] = "No script provided!";
                }
            }
            catch (Exception e) {
                result[0] = "Failed to initialize Jython script '" + file + "': " + e.toString();
                this.getLogger().log(Level.SEVERE, "Failed to initialize Jython script '" + file + "'!", e);
            }
        }
        return result;
    }

    public static synchronized Jython getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new Jython();
        }
        return m_Singleton;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        if (args.length == 0) {
            System.out.println("Jython present: " + Jython.getSingleton().isPresent());
        } else if (Jython.getSingleton().getInterpreter() == null) {
            System.err.println("Cannot instantiate Python Interpreter!");
        } else {
            Object jythonObject = Jython.getSingleton().newInstance(new File(args[0]), Object.class);
            if (jythonObject == null) {
                System.err.println("Failed to instantiate script: " + args[0]);
            } else {
                System.out.println("Successfully instantiated script: " + args[0]);
            }
        }
    }
}

