/*
 * Decompiled with CFR 0.152.
 */
package JSci.astro.telescope;

import JSci.astro.telescope.LX200;
import JSci.astro.telescope.LX200Remote;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public final class LX200Server
extends UnicastRemoteObject
implements LX200Remote {
    private final LX200 lx200;

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: LX200Server <com port> <remote name>");
            return;
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            Registry registry = LocateRegistry.createRegistry(1099);
            registry.rebind(stringArray[1], new LX200Server(new LX200(stringArray[0])));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public LX200Server(LX200 lX200) throws RemoteException {
        this.lx200 = lX200;
    }

    public void setFocusRate(int n) throws IOException, RemoteException {
        this.lx200.setFocusRate(n);
    }

    public void startFocus(int n) throws IOException, RemoteException {
        this.lx200.startFocus(n);
    }

    public void stopFocus() throws IOException, RemoteException {
        this.lx200.stopFocus();
    }

    public void setSlewRate(int n) throws IOException, RemoteException {
        this.lx200.setSlewRate(n);
    }

    public void startSlew(int n) throws IOException, RemoteException {
        this.lx200.startSlew(n);
    }

    public void stopSlew(int n) throws IOException, RemoteException {
        this.lx200.stopSlew(n);
    }

    public String getRA() throws IOException, RemoteException {
        return this.lx200.getRA();
    }

    public String getDec() throws IOException, RemoteException {
        return this.lx200.getDec();
    }

    public void setObjectCoords(String string, String string2) throws IOException, RemoteException {
        this.lx200.setObjectCoords(string, string2);
    }

    public int slewToObject() throws IOException, RemoteException {
        return this.lx200.slewToObject();
    }

    public void syncCoords() throws IOException, RemoteException {
        this.lx200.syncCoords();
    }
}

