/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.haar;

import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.splines.PiecewiseConstant;

public final class MultiSplineHaar
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 0;
    static final double[] vg = new double[]{1.0, 1.0};
    static final double[] vog = new double[]{0.7071067811865475, -0.7071067811865475};

    public int getFilterType() {
        return 0;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return MultiSplineHaar.scaling(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return MultiSplineHaar.scaling(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return MultiSplineHaar.wavelet(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return MultiSplineHaar.wavelet(n, n2);
    }

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)n / 2.0);
        if (2 * n2 == n) {
            return n2;
        }
        throw new IllegalScalingException("Odd number of values into an even Filter. Please change the number of values.");
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 1) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 1");
        }
        double[] dArray2 = new double[2 * dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            int n = 2 * i;
            dArray2[n] = dArray2[n] + dArray[i] * vg[0];
            int n2 = 2 * i + 1;
            dArray2[n2] = dArray2[n2] + dArray[i] * vg[1];
        }
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        if (dArray.length < 1) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 1");
        }
        double[] dArray2 = new double[2 * dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            int n = 2 * i;
            dArray2[n] = dArray2[n] + dArray[i] * vog[0];
            int n2 = 2 * i + 1;
            dArray2[n2] = dArray2[n2] + dArray[i] * vog[1];
        }
        return dArray2;
    }

    public static PiecewiseConstant scaling(int n, int n2) {
        if (n2 < 0 || n < 0 || n2 >= n) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + n2);
        }
        double[] dArray = new double[n];
        dArray[n2] = 1.0;
        return new PiecewiseConstant(dArray);
    }

    public static PiecewiseConstant wavelet(int n, int n2) {
        if (n2 < 0 || n < 0 || n2 >= n) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + n2);
        }
        double[] dArray = new double[2 * n];
        dArray[2 * n2] = vog[0];
        dArray[2 * n2 + 1] = vog[1];
        return new PiecewiseConstant(dArray);
    }
}

